/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import gloomyfolken.hooklib.helper.Logger;
import gloomyfolken.hooklib.minecraft.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public enum ClassDumper {
    instance;


    private ClassDumper() {
        if (Config.instance.dumpChangedClasses && Config.instance.dumpLocation.exists()) {
            try {
                FileUtils.deleteDirectory((File)Config.instance.dumpLocation);
            }
            catch (IOException e) {
                Logger.instance.error("Unable to delete previous hooked classes dump folder");
                e.printStackTrace();
            }
        }
    }

    public void dumpClass(String className, byte[] bytecode) {
        if (!Config.instance.dumpChangedClasses) {
            return;
        }
        File classLocation = new File(Config.instance.dumpLocation, className.replace('.', '/') + ".class");
        classLocation.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(classLocation);){
            Logger.instance.info("Saving hooked class " + className + " to " + classLocation);
            fos.write(bytecode);
        }
        catch (IOException e) {
            Logger.instance.warning("Unable to save hooked class " + className);
            e.printStackTrace();
        }
    }
}

