/*
 * Decompiled with CFR 0.152.
 */
package gloomyfolken.hooklib.asm;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class AsmUtils {
    public static BiMap<Type, Type> objectToPrimitive = ImmutableBiMap.builder().put((Object)Type.getType(Void.class), (Object)Type.VOID_TYPE).put((Object)Type.getType(Boolean.class), (Object)Type.BOOLEAN_TYPE).put((Object)Type.getType(Character.class), (Object)Type.CHAR_TYPE).put((Object)Type.getType(Byte.class), (Object)Type.BYTE_TYPE).put((Object)Type.getType(Short.class), (Object)Type.SHORT_TYPE).put((Object)Type.getType(Integer.class), (Object)Type.INT_TYPE).put((Object)Type.getType(Float.class), (Object)Type.FLOAT_TYPE).put((Object)Type.getType(Long.class), (Object)Type.LONG_TYPE).put((Object)Type.getType(Double.class), (Object)Type.DOUBLE_TYPE).build();
    public static Map<Type, String> primitiveToUnboxingMethod = ImmutableBiMap.builder().put((Object)Type.BOOLEAN_TYPE, (Object)"booleanValue").put((Object)Type.CHAR_TYPE, (Object)"charValue").put((Object)Type.BYTE_TYPE, (Object)"byteValue").put((Object)Type.SHORT_TYPE, (Object)"shortValue").put((Object)Type.INT_TYPE, (Object)"intValue").put((Object)Type.FLOAT_TYPE, (Object)"floatValue").put((Object)Type.LONG_TYPE, (Object)"longValue").put((Object)Type.DOUBLE_TYPE, (Object)"doubleValue").build();
    private static Set<Integer> returnOpcodes = new HashSet<Integer>(Arrays.asList(172, 173, 174, 175, 176, 177));
    private static Map<Integer, OpcodeDetails> opcodeDetails = ImmutableMap.builder().put((Object)1, (Object)new OpcodeDetails(0, 1, Type.getType(Object.class))).put((Object)2, (Object)new OpcodeDetails(0, 1, Type.INT_TYPE)).put((Object)3, (Object)new OpcodeDetails(0, 1, Type.INT_TYPE)).put((Object)4, (Object)new OpcodeDetails(0, 1, Type.INT_TYPE)).put((Object)5, (Object)new OpcodeDetails(0, 1, Type.INT_TYPE)).put((Object)6, (Object)new OpcodeDetails(0, 1, Type.INT_TYPE)).put((Object)7, (Object)new OpcodeDetails(0, 1, Type.INT_TYPE)).put((Object)8, (Object)new OpcodeDetails(0, 1, Type.INT_TYPE)).put((Object)9, (Object)new OpcodeDetails(0, 1, Type.LONG_TYPE)).put((Object)10, (Object)new OpcodeDetails(0, 1, Type.LONG_TYPE)).put((Object)11, (Object)new OpcodeDetails(0, 1, Type.FLOAT_TYPE)).put((Object)12, (Object)new OpcodeDetails(0, 1, Type.FLOAT_TYPE)).put((Object)13, (Object)new OpcodeDetails(0, 1, Type.FLOAT_TYPE)).put((Object)14, (Object)new OpcodeDetails(0, 1, Type.DOUBLE_TYPE)).put((Object)15, (Object)new OpcodeDetails(0, 1, Type.DOUBLE_TYPE)).put((Object)16, (Object)new OpcodeDetails(0, 1, Type.BYTE_TYPE)).put((Object)17, (Object)new OpcodeDetails(0, 1, Type.SHORT_TYPE)).put((Object)18, (Object)new OpcodeDetails(0, 1, i -> {
        Object cst = ((LdcInsnNode)i).cst;
        if (cst instanceof Type) {
            Type t = (Type)cst;
            int s = t.getSort();
            if (s == 10) {
                return Type.getType(Class.class);
            }
            return s == 11 ? Type.getType(String.class) : Type.getType(Class.class);
        }
        if (cst instanceof Handle) {
            throw new IllegalArgumentException("unsupported ldc: " + cst);
        }
        return Type.getType(cst.getClass());
    })).put((Object)21, (Object)new OpcodeDetails(0, 1, Type.INT_TYPE)).put((Object)22, (Object)new OpcodeDetails(0, 1, Type.LONG_TYPE)).put((Object)23, (Object)new OpcodeDetails(0, 1, Type.FLOAT_TYPE)).put((Object)24, (Object)new OpcodeDetails(0, 1, Type.DOUBLE_TYPE)).put((Object)25, (Object)new OpcodeDetails(0, 1, Type.getType(Object.class))).put((Object)46, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)47, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)48, (Object)new OpcodeDetails(2, 1, Type.FLOAT_TYPE)).put((Object)49, (Object)new OpcodeDetails(2, 1, Type.DOUBLE_TYPE)).put((Object)50, (Object)new OpcodeDetails(2, 1, Type.getType(Object.class))).put((Object)51, (Object)new OpcodeDetails(2, 1, Type.BYTE_TYPE)).put((Object)52, (Object)new OpcodeDetails(2, 1, Type.CHAR_TYPE)).put((Object)53, (Object)new OpcodeDetails(2, 1, Type.SHORT_TYPE)).put((Object)54, (Object)new OpcodeDetails(1, 0, Type.INT_TYPE)).put((Object)55, (Object)new OpcodeDetails(1, 0, Type.LONG_TYPE)).put((Object)56, (Object)new OpcodeDetails(1, 0, Type.FLOAT_TYPE)).put((Object)57, (Object)new OpcodeDetails(1, 0, Type.DOUBLE_TYPE)).put((Object)58, (Object)new OpcodeDetails(1, 0, Type.getType(Object.class))).put((Object)79, (Object)new OpcodeDetails(3, 0, Type.VOID_TYPE)).put((Object)80, (Object)new OpcodeDetails(3, 0, Type.VOID_TYPE)).put((Object)81, (Object)new OpcodeDetails(3, 0, Type.VOID_TYPE)).put((Object)82, (Object)new OpcodeDetails(3, 0, Type.VOID_TYPE)).put((Object)83, (Object)new OpcodeDetails(3, 0, Type.VOID_TYPE)).put((Object)84, (Object)new OpcodeDetails(3, 0, Type.VOID_TYPE)).put((Object)85, (Object)new OpcodeDetails(3, 0, Type.VOID_TYPE)).put((Object)86, (Object)new OpcodeDetails(3, 0, Type.VOID_TYPE)).put((Object)87, (Object)new OpcodeDetails(1, 0, Type.VOID_TYPE)).put((Object)88, (Object)new OpcodeDetails(1, 0, Type.VOID_TYPE)).put((Object)89, (Object)new OpcodeDetails(1, 2, i -> {
        throw new IllegalStateException("instruction have no easy predictable result type" + i);
    })).put((Object)90, (Object)new OpcodeDetails(2, 3, i -> {
        throw new IllegalStateException("instruction have no easy predictable result type" + i);
    })).put((Object)91, (Object)new OpcodeDetails(3, 4, i -> {
        throw new IllegalStateException("instruction have no easy predictable result type" + i);
    })).put((Object)92, (Object)new OpcodeDetails(1, 2, i -> {
        throw new IllegalStateException("instruction have no easy predictable result type" + i);
    })).put((Object)93, (Object)new OpcodeDetails(2, 3, i -> {
        throw new IllegalStateException("instruction have no easy predictable result type" + i);
    })).put((Object)94, (Object)new OpcodeDetails(3, 4, i -> {
        throw new IllegalStateException("instruction have no easy predictable result type" + i);
    })).put((Object)95, (Object)new OpcodeDetails(2, 2, i -> {
        throw new IllegalStateException("instruction have no easy predictable result type" + i);
    })).put((Object)96, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)97, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)98, (Object)new OpcodeDetails(2, 1, Type.FLOAT_TYPE)).put((Object)99, (Object)new OpcodeDetails(2, 1, Type.DOUBLE_TYPE)).put((Object)100, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)101, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)102, (Object)new OpcodeDetails(2, 1, Type.FLOAT_TYPE)).put((Object)103, (Object)new OpcodeDetails(2, 1, Type.DOUBLE_TYPE)).put((Object)104, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)105, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)106, (Object)new OpcodeDetails(2, 1, Type.FLOAT_TYPE)).put((Object)107, (Object)new OpcodeDetails(2, 1, Type.DOUBLE_TYPE)).put((Object)108, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)109, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)110, (Object)new OpcodeDetails(2, 1, Type.FLOAT_TYPE)).put((Object)111, (Object)new OpcodeDetails(2, 1, Type.DOUBLE_TYPE)).put((Object)112, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)113, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)114, (Object)new OpcodeDetails(2, 1, Type.FLOAT_TYPE)).put((Object)115, (Object)new OpcodeDetails(2, 1, Type.DOUBLE_TYPE)).put((Object)116, (Object)new OpcodeDetails(1, 1, Type.INT_TYPE)).put((Object)117, (Object)new OpcodeDetails(1, 1, Type.LONG_TYPE)).put((Object)118, (Object)new OpcodeDetails(1, 1, Type.FLOAT_TYPE)).put((Object)119, (Object)new OpcodeDetails(1, 1, Type.DOUBLE_TYPE)).put((Object)120, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)121, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)122, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)123, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)124, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)125, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)126, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)127, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)128, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)129, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)130, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)131, (Object)new OpcodeDetails(2, 1, Type.LONG_TYPE)).put((Object)132, (Object)new OpcodeDetails(0, 0, Type.VOID_TYPE)).put((Object)133, (Object)new OpcodeDetails(1, 1, Type.LONG_TYPE)).put((Object)134, (Object)new OpcodeDetails(1, 1, Type.FLOAT_TYPE)).put((Object)135, (Object)new OpcodeDetails(1, 1, Type.DOUBLE_TYPE)).put((Object)136, (Object)new OpcodeDetails(1, 1, Type.INT_TYPE)).put((Object)137, (Object)new OpcodeDetails(1, 1, Type.FLOAT_TYPE)).put((Object)138, (Object)new OpcodeDetails(1, 1, Type.DOUBLE_TYPE)).put((Object)139, (Object)new OpcodeDetails(1, 1, Type.INT_TYPE)).put((Object)140, (Object)new OpcodeDetails(1, 1, Type.LONG_TYPE)).put((Object)141, (Object)new OpcodeDetails(1, 1, Type.DOUBLE_TYPE)).put((Object)142, (Object)new OpcodeDetails(1, 1, Type.INT_TYPE)).put((Object)143, (Object)new OpcodeDetails(1, 1, Type.LONG_TYPE)).put((Object)144, (Object)new OpcodeDetails(1, 1, Type.FLOAT_TYPE)).put((Object)145, (Object)new OpcodeDetails(1, 1, Type.BYTE_TYPE)).put((Object)146, (Object)new OpcodeDetails(1, 1, Type.CHAR_TYPE)).put((Object)147, (Object)new OpcodeDetails(1, 1, Type.SHORT_TYPE)).put((Object)148, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)149, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)150, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)151, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)152, (Object)new OpcodeDetails(2, 1, Type.INT_TYPE)).put((Object)178, (Object)new OpcodeDetails(0, 1, i -> Type.getType((String)((FieldInsnNode)i).desc))).put((Object)180, (Object)new OpcodeDetails(0, 1, i -> Type.getType((String)((FieldInsnNode)i).desc))).put((Object)187, (Object)new OpcodeDetails(0, 1, i -> Type.getObjectType((String)((TypeInsnNode)i).desc))).put((Object)188, (Object)new OpcodeDetails(1, 1, Type.getType(Object.class))).put((Object)189, (Object)new OpcodeDetails(1, 1, Type.getType(Object.class))).put((Object)190, (Object)new OpcodeDetails(1, 1, Type.INT_TYPE)).put((Object)192, (Object)new OpcodeDetails(1, 1, i -> Type.getObjectType((String)((TypeInsnNode)i).desc))).put((Object)193, (Object)new OpcodeDetails(1, 1, Type.BOOLEAN_TYPE)).build();

    public static boolean isStatic(MethodNode methodNode) {
        return AsmUtils.isStatic(methodNode.access);
    }

    public static boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    public static boolean isPublic(MethodNode methodNode) {
        return (methodNode.access & 1) != 0;
    }

    public static boolean isReturn(AbstractInsnNode n) {
        return returnOpcodes.contains(n.getOpcode());
    }

    public static boolean isPatternSensitive(AbstractInsnNode n) {
        return !(n instanceof LineNumberNode) && !(n instanceof FrameNode) && !(n instanceof LabelNode);
    }

    public static OpcodeDetails getOpcodeDetails(int opcode) {
        OpcodeDetails r = opcodeDetails.get(opcode);
        if (r == null) {
            throw new IllegalArgumentException("Unsupported opcode type: " + opcode + ". Plz report to https://github.com/hohserg1/HookLib/issues");
        }
        return r;
    }

    public static final class OpcodeDetails {
        public final int consumeFromStack;
        public final int putToStack;
        public final Function<AbstractInsnNode, Type> resultType;

        public OpcodeDetails(int consumeFromStack, int putToStack, Type constantResultType) {
            this(consumeFromStack, putToStack, (AbstractInsnNode __) -> constantResultType);
        }

        public int getConsumeFromStack() {
            return this.consumeFromStack;
        }

        public int getPutToStack() {
            return this.putToStack;
        }

        public Function<AbstractInsnNode, Type> getResultType() {
            return this.resultType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OpcodeDetails)) {
                return false;
            }
            OpcodeDetails other = (OpcodeDetails)o;
            if (this.getConsumeFromStack() != other.getConsumeFromStack()) {
                return false;
            }
            if (this.getPutToStack() != other.getPutToStack()) {
                return false;
            }
            Function<AbstractInsnNode, Type> this$resultType = this.getResultType();
            Function<AbstractInsnNode, Type> other$resultType = other.getResultType();
            return !(this$resultType == null ? other$resultType != null : !this$resultType.equals(other$resultType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getConsumeFromStack();
            result = result * 59 + this.getPutToStack();
            Function<AbstractInsnNode, Type> $resultType = this.getResultType();
            result = result * 59 + ($resultType == null ? 43 : $resultType.hashCode());
            return result;
        }

        public String toString() {
            return "AsmUtils.OpcodeDetails(consumeFromStack=" + this.getConsumeFromStack() + ", putToStack=" + this.getPutToStack() + ", resultType=" + this.getResultType() + ")";
        }

        public OpcodeDetails(int consumeFromStack, int putToStack, Function<AbstractInsnNode, Type> resultType) {
            this.consumeFromStack = consumeFromStack;
            this.putToStack = putToStack;
            this.resultType = resultType;
        }
    }
}

