/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.interactions.util;

import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class IdUtil {
    public static String getBlockId(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return block.getRegistryName().toString() + ":" + block.func_176201_c(blockState);
    }

    public static String getItemId(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item.getRegistryName().toString() + ":" + itemStack.func_77960_j();
    }

    public static ItemStack createItemStackFrom(String itemId, int count) {
        String[] splitDropItemId = itemId.split(":");
        ItemStack newItemStack = new ItemStack(Item.func_111206_d((String)(splitDropItemId[0] + ":" + splitDropItemId[1])), count);
        newItemStack.func_77964_b(Integer.parseInt(splitDropItemId[2]));
        return newItemStack;
    }

    public static IBlockState getBlockStateFrom(String blockId) {
        String[] splitIntoBlockId = blockId.split(":");
        return Block.func_149684_b((String)(splitIntoBlockId[0] + ":" + splitIntoBlockId[1])).func_176203_a(Integer.parseInt(splitIntoBlockId[2]));
    }

    public static boolean itemIdsMatch(String itemId1, String itemId2) {
        if (IdUtil.createItemStackFrom(itemId1, 1).func_77984_f()) {
            String[] split2;
            String[] split1 = itemId1.split(":");
            return split1[0].equals((split2 = itemId2.split(":"))[0]) && split1[1].equals(split2[1]);
        }
        return itemId1.equals(itemId2);
    }

    public static boolean matches(String recipeObject, String gameObject) {
        String fixedRecipeObject = recipeObject.replaceAll("\\*", ".*");
        if (!gameObject.equals("minecraft:air:0") && recipeObject.startsWith("ore:")) {
            int[] x;
            for (int i : x = OreDictionary.getOreIDs((ItemStack)IdUtil.createItemStackFrom(gameObject, 1))) {
                if (!Pattern.matches(fixedRecipeObject, "ore:" + OreDictionary.getOreName((int)i) + ":0")) continue;
                return true;
            }
            return false;
        }
        return Pattern.matches(fixedRecipeObject, gameObject);
    }

    public static String fixMetadata(String metadata, IdType idType) {
        String[] splitMetadata = metadata.split(":");
        if (splitMetadata.length == 2) {
            switch (idType) {
                case CHECK: {
                    return metadata + ":*";
                }
                case OBJ: {
                    return metadata + ":0";
                }
            }
            return metadata;
        }
        return metadata;
    }

    public static enum IdType {
        CHECK,
        OBJ;

    }
}

