/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.interactions.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import us.timinc.interactions.recipe.InteractRecipe;

public class InteractRecipes {
    private ArrayList<InteractRecipe> recipes = new ArrayList();
    private Gson gson = new Gson();

    public InteractRecipes() {
        this.loadRecipes();
    }

    private void add(InteractRecipe recipe) {
        this.recipes.add(recipe);
    }

    private void addRecipesFrom(File file) throws JsonSyntaxException, JsonIOException, FileNotFoundException {
        InteractRecipe[] newRecipes = (InteractRecipe[])this.gson.fromJson((Reader)new FileReader(file), InteractRecipe[].class);
        for (int i = 0; i < newRecipes.length; ++i) {
            newRecipes[i].fixMetadata();
            this.add(newRecipes[i]);
        }
    }

    private void loadRecipes() {
        File globalDir = new File("interactions");
        if (!globalDir.exists()) {
            globalDir.mkdirs();
        }
        String[] files = globalDir.list();
        files = (String[])Arrays.stream(files).filter(x -> x.endsWith(".json")).toArray(String[]::new);
        for (int i = 0; i < files.length; ++i) {
            try {
                this.addRecipesFrom(new File(globalDir, files[i]));
                continue;
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public int getRecipeCount() {
        return this.recipes.size();
    }

    public ArrayList<InteractRecipe> findMatches(PlayerInteractEvent.RightClickBlock event) {
        return (ArrayList)this.recipes.stream().filter(r -> r.matches(event)).collect(Collectors.toList());
    }
}

