/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.interactions.recipe;

import com.google.gson.annotations.SerializedName;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import us.timinc.interactions.util.IdUtil;
import us.timinc.interactions.util.RandUtil;

public class InteractRecipe {
    @SerializedName(value="targetBlock")
    public String targetBlockId = "";
    @SerializedName(value="heldItem")
    public String heldItemId = "";
    @SerializedName(value="replacementBlock")
    public String replacementBlockId = "";
    public String replacementChance = "";
    @SerializedName(value="dropItem")
    public String dropItemId = "";
    public String dropOnlyOnSuccess = "false";
    public String dropChance = "";
    public String dropCount = "1";
    public String damage = "";
    public String damageOnlyOnSuccess = "false";
    public String damageChance = "";
    public String particleType = "";
    public String particleArea = "in";
    public String particleCount = "15";

    public boolean changesTargetBlock() {
        return !this.replacementBlockId.isEmpty();
    }

    public boolean dropsItem(boolean success) {
        if (this.dropRequiresSuccess() && !success) {
            return false;
        }
        return !this.dropItemId.isEmpty();
    }

    public boolean dropRequiresSuccess() {
        return Boolean.parseBoolean(this.dropOnlyOnSuccess);
    }

    public boolean damagesHeldItem(boolean success) {
        if (this.damageRequiresSuccess() && !success) {
            return false;
        }
        return !this.damage.isEmpty();
    }

    public boolean damageRequiresSuccess() {
        return Boolean.parseBoolean(this.damageOnlyOnSuccess);
    }

    public boolean rollForChangeBlock() {
        return this.replacementChance.isEmpty() || this.rollFor(this.replacementChance);
    }

    public boolean rollForDropItem() {
        return this.dropChance.isEmpty() || this.rollFor(this.dropChance);
    }

    public boolean rollForDamageItem() {
        return this.damageChance.isEmpty() || this.rollFor(this.damageChance);
    }

    private boolean rollFor(String chance) {
        String[] splitChance = chance.split(":");
        return RandUtil.rollSuccess(Integer.parseInt(splitChance[1]), Integer.parseInt(splitChance[0]) + 1);
    }

    public IBlockState getChangeBlockState() {
        return IdUtil.getBlockStateFrom(this.replacementBlockId);
    }

    public ItemStack createDrop() {
        ItemStack dropped = IdUtil.createItemStackFrom(this.dropItemId, this.rollForDropCount());
        return dropped;
    }

    public int rollForDropCount() {
        if (!this.dropCount.contains(":")) {
            return Integer.parseInt(this.dropCount);
        }
        String[] splitCount = this.dropCount.split(":");
        return RandUtil.roll(Integer.parseInt(splitCount[0]), Integer.parseInt(splitCount[1]));
    }

    public int getDamage() {
        if (!this.damagesHeldItem(true)) {
            return 0;
        }
        return Integer.parseInt(this.damage);
    }

    public boolean spawnsParticles() {
        return !this.particleType.isEmpty();
    }

    public int rollForParticleCount() {
        if (!this.particleCount.contains(":")) {
            return Integer.parseInt(this.particleCount);
        }
        String[] splitCount = this.particleCount.split(":");
        return RandUtil.roll(Integer.parseInt(splitCount[0]), Integer.parseInt(splitCount[1]));
    }

    public String getParticleName() {
        String[] splitParticleType = this.particleType.split(":");
        return splitParticleType[0];
    }

    public String getParticleParam() {
        String[] splitParticleType = this.particleType.split(":");
        if (splitParticleType.length == 1) {
            return this.targetBlockId.replace('*', '0');
        }
        return splitParticleType[1] + ":" + splitParticleType[2] + ":" + splitParticleType[3];
    }

    public String getParticleArea() {
        return this.particleArea;
    }

    public boolean matches(PlayerInteractEvent.RightClickBlock event) {
        return IdUtil.matches(this.heldItemId, IdUtil.getItemId(event.getItemStack())) && IdUtil.matches(this.targetBlockId, IdUtil.getBlockId(event.getWorld().func_180495_p(event.getPos())));
    }

    public void fixMetadata() {
        this.targetBlockId = IdUtil.fixMetadata(this.targetBlockId, IdUtil.IdType.CHECK);
        if (!this.heldItemId.isEmpty()) {
            this.heldItemId = IdUtil.fixMetadata(this.heldItemId, IdUtil.IdType.CHECK);
        }
        if (!this.replacementBlockId.isEmpty()) {
            this.replacementBlockId = IdUtil.fixMetadata(this.replacementBlockId, IdUtil.IdType.OBJ);
        }
        if (!this.dropItemId.isEmpty()) {
            this.dropItemId = IdUtil.fixMetadata(this.dropItemId, IdUtil.IdType.OBJ);
        }
    }
}

