/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPSapling;
import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockFruit;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyWater;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.LeavesPropertiesJson;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.google.gson.JsonElement;
import dynamictreesbop.ModConfigs;
import dynamictreesbop.blocks.BlockDynamicLeavesFlowering;
import dynamictreesbop.blocks.BlockDynamicLeavesPalm;
import dynamictreesbop.items.ItemMagicSeed;
import dynamictreesbop.items.ItemMapleSeed;
import dynamictreesbop.trees.TreeBamboo;
import dynamictreesbop.trees.TreeCherry;
import dynamictreesbop.trees.TreeDead;
import dynamictreesbop.trees.TreeEbony;
import dynamictreesbop.trees.TreeEucalyptus;
import dynamictreesbop.trees.TreeFir;
import dynamictreesbop.trees.TreeHellbark;
import dynamictreesbop.trees.TreeJacaranda;
import dynamictreesbop.trees.TreeMagic;
import dynamictreesbop.trees.TreeMahogany;
import dynamictreesbop.trees.TreeMangrove;
import dynamictreesbop.trees.TreePalm;
import dynamictreesbop.trees.TreePine;
import dynamictreesbop.trees.TreeRedwood;
import dynamictreesbop.trees.TreeUmbran;
import dynamictreesbop.trees.TreeWillow;
import dynamictreesbop.trees.species.SpeciesAcaciaBrush;
import dynamictreesbop.trees.species.SpeciesAcaciaBrushBush;
import dynamictreesbop.trees.species.SpeciesAcaciaBush;
import dynamictreesbop.trees.species.SpeciesAcaciaTwiglet;
import dynamictreesbop.trees.species.SpeciesDarkOakConifer;
import dynamictreesbop.trees.species.SpeciesDarkOakDyingConifer;
import dynamictreesbop.trees.species.SpeciesDeadBrushBush;
import dynamictreesbop.trees.species.SpeciesDyingOak;
import dynamictreesbop.trees.species.SpeciesFloweringApple;
import dynamictreesbop.trees.species.SpeciesFloweringOak;
import dynamictreesbop.trees.species.SpeciesJungleTwiglet;
import dynamictreesbop.trees.species.SpeciesMaple;
import dynamictreesbop.trees.species.SpeciesMapleTwiglet;
import dynamictreesbop.trees.species.SpeciesMegaOakConifer;
import dynamictreesbop.trees.species.SpeciesOakBush;
import dynamictreesbop.trees.species.SpeciesOakConifer;
import dynamictreesbop.trees.species.SpeciesOakIvyVines;
import dynamictreesbop.trees.species.SpeciesOakSparse;
import dynamictreesbop.trees.species.SpeciesOakTwiglet;
import dynamictreesbop.trees.species.SpeciesOrangeAutumn;
import dynamictreesbop.trees.species.SpeciesPeach;
import dynamictreesbop.trees.species.SpeciesPear;
import dynamictreesbop.trees.species.SpeciesPersimmon;
import dynamictreesbop.trees.species.SpeciesPoplar;
import dynamictreesbop.trees.species.SpeciesSpruceBush;
import dynamictreesbop.trees.species.SpeciesYellowAutumn;
import dynamictreesbop.worldgen.BiomeDataBasePopulator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dynamictreesbop")
public class ModContent {
    public static BlockRootyWater rootyWater;
    public static BlockDynamicLeavesFlowering floweringOakLeaves;
    public static BlockDynamicLeavesFlowering peachLeaves;
    public static BlockDynamicLeavesPalm palmFrondLeaves;
    public static ILeavesProperties decayedLeavesProperties;
    public static ILeavesProperties palmLeavesProperties;
    public static ILeavesProperties[] floweringOakLeavesProperties;
    public static ILeavesProperties[] peachLeavesProperties;
    public static Map<String, ILeavesProperties> leaves;
    public static ILeavesProperties[] basicLeavesProperties;
    public static ArrayList<TreeFamily> trees;
    public static BlockFruit persimmonFruit;
    public static BlockFruit peachFruit;
    public static BlockFruit pearFruit;
    public static final String ACACIA = "acacia";
    public static final String APPLE = "apple";
    public static final String BIRCH = "birch";
    public static final String CACTUS = "cactus";
    public static final String DARKOAK = "darkoak";
    public static final String JUNGLE = "jungle";
    public static final String OAK = "oak";
    public static final String OAKSWAMP = "oakswamp";
    public static final String SPRUCE = "spruce";
    public static final String MUSHROOMRED = "mushroomred";
    public static final String MUSHROOMBRN = "mushroombrn";
    public static final String ACACIABRUSH = "acaciabrush";
    public static final String ACACIABUSH = "acaciabush";
    public static final String ACACIABRUSHBUSH = "acaciabrushbush";
    public static final String ACACIATWIGLET = "acaciatwiglet";
    public static final String BAMBOO = "bamboo";
    public static final String CHERRY = "cherry";
    public static final String DARKOAKCONIFER = "darkoakconifer";
    public static final String DARKOAKDYINGCONIFER = "darkoakdyingconifer";
    public static final String DARKPOPLAR = "darkpoplar";
    public static final String DEAD = "dead";
    public static final String DEADBRUSHBUSH = "deadbrushbush";
    public static final String DECAYED = "decayed";
    public static final String EBONY = "ebony";
    public static final String EBONYTWIGLET = "ebonytwiglet";
    public static final String EUCALYPTUS = "eucalyptus";
    public static final String FIR = "fir";
    public static final String FLOWERINGOAK = "floweringoak";
    public static final String HELLBARK = "hellbark";
    public static final String JACARANDA = "jacaranda";
    public static final String JUNGLETWIGLET = "jungletwiglet";
    public static final String MAGIC = "magic";
    public static final String MAPLE = "maple";
    public static final String MAPLETWIGLET = "mapletwiglet";
    public static final String MAHOGANY = "mahogany";
    public static final String MANGROVE = "mangrove";
    public static final String MEGAOAKCONIFER = "megaoakconifer";
    public static final String OAKBUSH = "oakbush";
    public static final String OAKCONIFER = "oakconifer";
    public static final String OAKDYING = "oakdying";
    public static final String OAKIVYVINE = "oakivyvines";
    public static final String OAKSPARSE = "oaksparse";
    public static final String OAKTWIGLET = "oaktwiglet";
    public static final String ORANGEAUTUMN = "orangeautumn";
    public static final String PALM = "palm";
    public static final String PINE = "pine";
    public static final String PINKCHERRY = "pinkcherry";
    public static final String POPLAR = "poplar";
    public static final String REDWOOD = "redwood";
    public static final String SPRUCEBUSH = "sprucebush";
    public static final String UMBRAN = "umbran";
    public static final String UMBRANCONIFER = "umbranconifer";
    public static final String UMBRANCONIFERMEGA = "umbranconifermega";
    public static final String WHITECHERRY = "whitecherry";
    public static final String WILLOW = "willow";
    public static final String YELLOWAUTUMN = "yellowautumn";
    public static final String FLOWERINGAPPLE = "floweringapple";
    public static final String PERSIMMONOAK = "persimmon";
    public static final String PEACHOAK = "peach";
    public static final String PEAROAK = "pear";
    public static final String REMOVEBOPGEN = "removebopgen";

    private static AxisAlignedBB createBox(float radius, float height, float stemLength, float fraction) {
        float topHeight = fraction - stemLength;
        float bottomHeight = topHeight - height;
        return new AxisAlignedBB((double)((fraction / 2.0f - radius) / fraction), (double)(topHeight / fraction), (double)((fraction / 2.0f - radius) / fraction), (double)((fraction / 2.0f + radius) / fraction), (double)(bottomHeight / fraction), (double)((fraction / 2.0f + radius) / fraction));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        rootyWater = new BlockRootyWater(false);
        registry.register((IForgeRegistryEntry)rootyWater);
        floweringOakLeaves = new BlockDynamicLeavesFlowering("leaves_flowering");
        peachLeaves = new BlockDynamicLeavesFlowering("leaves_flowering_peach");
        palmFrondLeaves = new BlockDynamicLeavesPalm();
        registry.registerAll((IForgeRegistryEntry[])new Block[]{floweringOakLeaves, peachLeaves, palmFrondLeaves});
        persimmonFruit = new BlockFruit("fruit_persimmon"){
            protected final AxisAlignedBB[] FRUIT_AABB = new AxisAlignedBB[]{ModContent.access$000(1.0f, 1.0f, 0.0f, 16.0f), ModContent.access$000(1.0f, 2.0f, 0.0f, 16.0f), ModContent.access$000(2.0f, 4.0f, 0.0f, 20.0f), ModContent.access$000(2.0f, 4.0f, 1.25f, 20.0f)};

            @SideOnly(value=Side.CLIENT)
            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }

            public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
                return this.FRUIT_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
            }
        }.setDroppedItem(new ItemStack(BOPItems.persimmon));
        peachFruit = new BlockFruit("fruit_peach"){

            @SideOnly(value=Side.CLIENT)
            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }
        }.setDroppedItem(new ItemStack(BOPItems.peach));
        pearFruit = new BlockFruit("fruit_pear"){
            protected final AxisAlignedBB[] FRUIT_AABB = new AxisAlignedBB[]{ModContent.access$000(1.0f, 1.0f, 0.0f, 16.0f), ModContent.access$000(1.0f, 2.0f, 0.0f, 16.0f), ModContent.access$000(2.0f, 6.0f, 0.0f, 20.0f), ModContent.access$000(2.0f, 6.0f, 1.25f, 20.0f)};

            @SideOnly(value=Side.CLIENT)
            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }

            public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
                return this.FRUIT_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
            }
        }.setDroppedItem(new ItemStack(BOPItems.pear));
        registry.registerAll((IForgeRegistryEntry[])new Block[]{persimmonFruit, peachFruit, pearFruit});
        DirtHelper.registerSoil((Block)BOPBlocks.grass, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BOPBlocks.dirt, (String)"dirtlike");
        DirtHelper.registerSoil((Block)BOPBlocks.white_sand, (String)"sandlike");
        DirtHelper.registerSoil((Block)BOPBlocks.mud, (String)"mudlike");
        LeavesPropertiesJson.addLeavesFinderFunction((String)"bop", (Function)new Function<JsonElement, LeavesPropertiesJson.PrimitiveLeavesComponents>(){

            @Override
            public LeavesPropertiesJson.PrimitiveLeavesComponents apply(JsonElement element) {
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    String searchData = element.getAsString();
                    for (BOPTrees tree : BOPTrees.values()) {
                        if (!tree.func_176610_l().equals(searchData.toLowerCase())) continue;
                        return new LeavesPropertiesJson.PrimitiveLeavesComponents(BlockBOPLeaves.paging.getVariantState((Enum)tree), BlockBOPLeaves.paging.getVariantItem((Enum)tree));
                    }
                }
                return null;
            }
        });
        leaves = LeavesPaging.build((String)"dynamictreesbop", (ResourceLocation)new ResourceLocation("dynamictreesbop", "leaves/common.json"));
        decayedLeavesProperties = new LeavesPropertiesJson("{`cellkit`:`bare`}");
        floweringOakLeavesProperties = new ILeavesProperties[]{new LeavesProperties(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK), new ItemStack((Block)Blocks.field_150362_t, 1, BlockPlanks.EnumType.OAK.func_176839_a())){
            Random rand = new Random();

            public IBlockState getDynamicLeavesState(int hydro) {
                if (this.rand.nextInt(4) == 0) {
                    return super.getDynamicLeavesState(hydro).func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(3));
                }
                return super.getDynamicLeavesState(hydro);
            }
        }, new LeavesProperties(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK), BlockBOPLeaves.paging.getVariantItem((Enum)BOPTrees.FLOWERING))};
        peachLeavesProperties = new ILeavesProperties[]{new LeavesProperties(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK), new ItemStack((Block)Blocks.field_150362_t, 1, BlockPlanks.EnumType.OAK.func_176839_a())){
            Random rand = new Random();

            public IBlockState getDynamicLeavesState(int hydro) {
                if (this.rand.nextInt(4) == 0) {
                    return super.getDynamicLeavesState(hydro).func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(3));
                }
                return super.getDynamicLeavesState(hydro);
            }
        }, new LeavesProperties(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK), BlockBOPLeaves.paging.getVariantItem((Enum)BOPTrees.FLOWERING))};
        palmLeavesProperties = new LeavesProperties(BlockBOPLeaves.paging.getVariantState((Enum)BOPTrees.PALM), BlockBOPLeaves.paging.getVariantItem((Enum)BOPTrees.PALM), TreeRegistry.findCellKit((String)PALM)){

            public boolean appearanceChangesWithHydro() {
                return true;
            }
        };
        floweringOakLeavesProperties[0].setDynamicLeavesState(floweringOakLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        floweringOakLeavesProperties[1].setDynamicLeavesState(floweringOakLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(2)));
        floweringOakLeaves.setProperties(0, floweringOakLeavesProperties[0]);
        floweringOakLeaves.setProperties(1, floweringOakLeavesProperties[0]);
        floweringOakLeaves.setProperties(2, floweringOakLeavesProperties[1]);
        floweringOakLeaves.setProperties(3, floweringOakLeavesProperties[1]);
        peachLeavesProperties[0].setDynamicLeavesState(peachLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(0)));
        peachLeavesProperties[1].setDynamicLeavesState(peachLeaves.func_176223_P().func_177226_a((IProperty)BlockDynamicLeaves.TREE, (Comparable)Integer.valueOf(2)));
        peachLeaves.setProperties(0, peachLeavesProperties[0]);
        peachLeaves.setProperties(1, peachLeavesProperties[0]);
        peachLeaves.setProperties(2, peachLeavesProperties[1]);
        peachLeaves.setProperties(3, peachLeavesProperties[1]);
        palmLeavesProperties.setDynamicLeavesState(palmFrondLeaves.func_176223_P());
        palmFrondLeaves.setProperties(0, palmLeavesProperties);
        TreeFamily oakTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", OAK)).getFamily();
        TreeFamily birchTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", BIRCH)).getFamily();
        TreeFamily jungleTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", JUNGLE)).getFamily();
        TreeFamily acaciaTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", ACACIA)).getFamily();
        TreeFamily darkOakTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", DARKOAK)).getFamily();
        SpeciesJungleTwiglet jungleTwiglet = new SpeciesJungleTwiglet(jungleTree);
        SpeciesAcaciaTwiglet acaciaTwiglet = new SpeciesAcaciaTwiglet(acaciaTree);
        Species.REGISTRY.registerAll((IForgeRegistryEntry[])new Species[]{new SpeciesOakIvyVines(oakTree), new SpeciesFloweringOak(oakTree), new SpeciesYellowAutumn(birchTree), new SpeciesOrangeAutumn(darkOakTree), new SpeciesDyingOak(oakTree), new SpeciesMaple(oakTree), new SpeciesOakConifer(oakTree), new SpeciesMegaOakConifer(oakTree), new SpeciesDarkOakConifer(darkOakTree), new SpeciesDarkOakDyingConifer(darkOakTree), new SpeciesOakTwiglet(oakTree), new SpeciesPoplar(birchTree, POPLAR), new SpeciesPoplar(darkOakTree, DARKPOPLAR), jungleTwiglet, acaciaTwiglet, new SpeciesAcaciaBrush(acaciaTree), new SpeciesOakSparse(oakTree), new SpeciesMapleTwiglet(oakTree), new SpeciesFloweringApple(oakTree), new SpeciesPersimmon(oakTree), new SpeciesPeach(oakTree), new SpeciesPear(oakTree), new SpeciesAcaciaBush(), new SpeciesOakBush(), new SpeciesSpruceBush(), new SpeciesAcaciaBrushBush(), new SpeciesDeadBrushBush()});
        jungleTree.addSpeciesLocationOverride((world, pos) -> {
            Biome biome = (Biome)BOPBiomes.oasis.orNull();
            if (biome != null && world.func_180494_b(pos) == biome) {
                return jungleTwiglet;
            }
            return Species.NULLSPECIES;
        });
        acaciaTree.addSpeciesLocationOverride((world, pos) -> {
            Biome biome = (Biome)BOPBiomes.xeric_shrubland.orNull();
            if (biome != null && world.func_180494_b(pos) == biome) {
                return acaciaTwiglet;
            }
            return Species.NULLSPECIES;
        });
        Collections.addAll(trees, new TreeFamily[]{new TreeMagic(), new TreeUmbran(), new TreeFir(), new TreeCherry(), new TreeDead(), new TreeJacaranda(), new TreeRedwood(), new TreeWillow(), new TreeHellbark(), new TreePine(), new TreePalm(), new TreeMahogany(), new TreeMangrove(), new TreeEbony(), new TreeBamboo(), new TreeEucalyptus()});
        trees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreesbop").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ModContent.getSpeciesSeed(FLOWERINGOAK), ModContent.getSpeciesSeed(YELLOWAUTUMN), ModContent.getSpeciesSeed(ORANGEAUTUMN), ModContent.getSpeciesSeed(OAKDYING), ModContent.getSpeciesSeed(MAPLE), ModContent.getSpeciesSeed(PERSIMMONOAK), ModContent.getSpeciesSeed(PEACHOAK), ModContent.getSpeciesSeed(PEAROAK), ModContent.getSpeciesSeed(POPLAR), ModContent.getSpeciesSeed(DARKPOPLAR)});
        ArrayList treeItems = new ArrayList();
        trees.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        event.getRegistry().registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[0]));
    }

    private static Item getSpeciesSeed(String name) {
        return TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", name)).getSeed();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int id = 0;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("dynamictreesbop", "maple_seed"), ItemMapleSeed.EntityItemMapleSeed.class, (String)"maple_seed", (int)id++, (Object)"dynamictreesbop", (int)32, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("dynamictreesbop", "magic_seed"), ItemMagicSeed.EntityItemMagicSeed.class, (String)"magic_seed", (int)id++, (Object)"dynamictreesbop", (int)32, (int)1, (boolean)true);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (String name : new String[]{MAGIC, UMBRANCONIFER, UMBRAN, FIR, WHITECHERRY, PINKCHERRY, JACARANDA, REDWOOD, WILLOW, HELLBARK, PINE, MAHOGANY, EBONY, EUCALYPTUS}) {
            ModContent.addTransformationPotion(name);
        }
        ItemStack outputStack = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", DEAD)).getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", DEAD)).getSeedStack(1), (ItemStack)outputStack);
        ModContent.addSeedExchange(BOPTrees.FLOWERING, FLOWERINGOAK);
        ModContent.addSeedExchange(BOPTrees.YELLOW_AUTUMN, YELLOWAUTUMN);
        ModContent.addSeedExchange(BOPTrees.ORANGE_AUTUMN, ORANGEAUTUMN);
        ModContent.addSeedExchange(BOPTrees.DEAD, OAKDYING);
        ModContent.addSeedExchange(BOPTrees.MAPLE, MAPLE);
        ModContent.addSeedExchange(BOPTrees.MAGIC, MAGIC);
        ModContent.addSeedExchange(BOPTrees.UMBRAN, UMBRAN);
        ModContent.addSeedExchange(BOPTrees.FIR, FIR);
        ModContent.addSeedExchange(BOPTrees.WHITE_CHERRY, WHITECHERRY);
        ModContent.addSeedExchange(BOPTrees.PINK_CHERRY, PINKCHERRY);
        ModContent.addSeedExchange(BOPTrees.JACARANDA, JACARANDA);
        ModContent.addSeedExchange(BOPTrees.REDWOOD, REDWOOD);
        ModContent.addSeedExchange(BOPTrees.WILLOW, WILLOW);
        ModContent.addSeedExchange(BOPTrees.HELLBARK, HELLBARK);
        ModContent.addSeedExchange(BOPTrees.PINE, PINE);
        ModContent.addSeedExchange(BOPTrees.PALM, PALM);
        ModContent.addSeedExchange(BOPTrees.MAHOGANY, MAHOGANY);
        ModContent.addSeedExchange(BOPTrees.MANGROVE, MANGROVE);
        ModContent.addSeedExchange(BOPTrees.EBONY, EBONY);
        ModContent.addSeedExchange(BOPTrees.BAMBOO, BAMBOO);
        ModContent.addSeedExchange(BOPTrees.EUCALYPTUS, EUCALYPTUS);
        ItemStack saplingStack = BlockBOPSapling.paging.getVariantItem((Enum)BOPTrees.UMBRAN);
        ItemStack seedStack = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", UMBRANCONIFER)).getSeedStack(1);
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("dynamictreesbop", "umbranconifersapling"), null, (ItemStack)saplingStack, (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{seedStack}), Ingredient.func_193367_a((Item)ModItems.dirtBucket)});
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)seedStack);
        if (ModConfigs.enablePersimmonTrees) {
            ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack(BOPItems.persimmon), (ItemStack)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", PERSIMMONOAK)).getSeedStack(1), (boolean)false);
        }
        if (ModConfigs.enablePeachTrees) {
            ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack(BOPItems.peach), (ItemStack)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", PEACHOAK)).getSeedStack(1), (boolean)false);
        }
        if (ModConfigs.enablePearTrees) {
            ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack(BOPItems.pear), (ItemStack)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", PEAROAK)).getSeedStack(1), (boolean)false);
        }
    }

    private static void addTransformationPotion(String tree) {
        Species species = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", tree));
        ItemStack outputStack = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), species.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)species.getSeedStack(1), (ItemStack)outputStack);
    }

    private static void addSeedExchange(BOPTrees saplingType, String species) {
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)BlockBOPSapling.paging.getVariantItem((Enum)saplingType), (ItemStack)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", species)).getSeedStack(1), (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomStateMapper((Block)rootyWater, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRootyWater.LIFE, BlockLiquid.field_176367_b}).func_178441_a());
        for (TreeFamily tree : trees) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        for (String name : new String[]{FLOWERINGOAK, YELLOWAUTUMN, ORANGEAUTUMN, OAKDYING, MAPLE, UMBRANCONIFER, WHITECHERRY, PERSIMMONOAK, PEACHOAK, PEAROAK, POPLAR, DARKPOPLAR}) {
            ModelHelper.regModel((Item)ModContent.getSpeciesSeed(name));
        }
        for (int i = 1; i <= 3; ++i) {
            ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictreesbop", MAGIC)).getSeed(), (int)i);
        }
        ModelLoader.setCustomStateMapper((Block)palmLeavesProperties.getDynamicLeavesState().func_177230_c(), (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDynamicLeaves.TREE}).func_178441_a());
    }

    @SubscribeEvent
    public static void registerDataBaseCapability(WorldGenRegistry.BiomeDataBaseJsonCapabilityRegistryEvent event) {
        event.register(REMOVEBOPGEN, (database, element, biome) -> {
            if (biome instanceof BOPBiome) {
                ArrayList<String> featuresToRemove = new ArrayList<String>();
                if (element.isJsonPrimitive()) {
                    featuresToRemove.add(element.getAsString());
                } else if (element.isJsonArray()) {
                    for (JsonElement e : element.getAsJsonArray()) {
                        if (!e.isJsonPrimitive()) continue;
                        featuresToRemove.add(e.getAsString());
                    }
                }
                for (String featureName : featuresToRemove) {
                    if (CACTUS.equals(featureName) && com.ferreusveritas.dynamictrees.ModConfigs.vanillaCactusWorldGen) {
                        return;
                    }
                    ((BOPBiome)biome).removeGenerator(featureName);
                }
            }
        });
    }

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    static /* synthetic */ AxisAlignedBB access$000(float x0, float x1, float x2, float x3) {
        return ModContent.createBox(x0, x1, x2, x3);
    }

    static {
        trees = new ArrayList();
    }
}

