/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.redstoneminus;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.redstoneminus.EnergyWorldTrackerEveryone;
import pl.asie.redstoneminus.EnergyWorldTrackerListBased;
import pl.asie.redstoneminus.IEnergyWorldTracker;
import pl.asie.redstoneminus.ProxyCommon;
import pl.asie.redstoneminus.RedstoneInductiveCharger;

@Mod(modid="redstoneminusredstone", name="Redstone Minus Redstone", version="@VERSION@", acceptedMinecraftVersions="[1.12.2]")
public class RedstoneMinusRedstone {
    public static final String MODID = "redstoneminusredstone";
    public static final String VERSION = "@VERSION@";
    public static Logger logger;
    @SidedProxy(serverSide="pl.asie.redstoneminus.ProxyCommon", clientSide="pl.asie.redstoneminus.ProxyClient")
    public static ProxyCommon proxy;
    static float[] powerRamp;
    static float[] powerRampItemCharging;
    static Set<Block> blocks;
    static Set<Item> inductiveItems;
    static boolean disableOptimizations;
    static boolean enableRedstonePower;
    static boolean enableInductiveCharging;
    static boolean preventDespawnInductiveCharging;
    static int tickGrouping;
    private static String[] cfgBlockIds;
    private static String[] cfgInductiveItemIds;
    private Map<World, IEnergyWorldTracker> worldTrackers = new IdentityHashMap<World, IEnergyWorldTracker>();

    private float[] readPowerRamp(String name, Configuration config) {
        float[] ramp = new float[15];
        String[] prStrDef = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
        String[] powerRampStr = config.getStringList(name, "balance", prStrDef, "The mapping of redstone values {1, 2, ... 15} to energy units. Must have exactly fifteen entries.");
        if (powerRampStr.length != prStrDef.length) {
            powerRampStr = prStrDef;
            config.get("balance", "powerRamp", prStrDef).set(prStrDef);
        }
        for (int i = 0; i < powerRampStr.length; ++i) {
            try {
                ramp[i] = Float.parseFloat(powerRampStr[i].trim());
                if (!(ramp[i] < 0.0f)) continue;
                logger.error("Invalid value @ " + i + ": " + ramp[i] + " < 0!");
                ramp[i] = 0.0f;
                continue;
            }
            catch (Exception e) {
                logger.error("Invalid value @ " + i, (Throwable)e);
                ramp[i] = 0.0f;
            }
        }
        return ramp;
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        logger = LogManager.getLogger((String)MODID);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        powerRamp = this.readPowerRamp("powerRamp", config);
        powerRampItemCharging = this.readPowerRamp("powerRampItemCharging", config);
        preventDespawnInductiveCharging = config.getBoolean("preventDespawningItems", "balance", true, "If true, items which can be charged 'inductively' will not be despawned.");
        cfgBlockIds = config.getStringList("allowedBlocks", "balance", new String[0], "If any valid entries are present, only blocks with these IDs will be powerable with redstone. This also helps performance.");
        cfgInductiveItemIds = config.getStringList("allowedChargeableItems", "balance", new String[0], "If any valid entries are present, only items with these IDs will be chargeable with redstone when thrown.");
        disableOptimizations = config.getBoolean("disableOptimizations", "performance", false, "Disable this if the mod author tells you to, or if you want to provide extra information for a bug report.");
        tickGrouping = config.getInt("executionTickDivider", "performance", 1, 1, 100, "Run the redstone charging code every X ticks, multiplying the power ramp by said X. As such, the total amount of energy is unchanged, but performance costs are reduced.");
        enableRedstonePower = config.getBoolean("redstoneGeneratesForgeEnergy", "features", true, "Enable the 'redstone power generates Forge Energy (commonly referred to as RF)' feature.");
        enableInductiveCharging = config.getBoolean("redstoneChargesItemsForgeEnergy", "features", true, "Enable the 'redstone charges thrown items containing Forge Energy' feature.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (enableInductiveCharging) {
            MinecraftForge.EVENT_BUS.register((Object)new RedstoneInductiveCharger());
        }
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        Block b;
        for (String s : cfgBlockIds) {
            b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s.trim()));
            if (b == null) continue;
            blocks.add(b);
        }
        for (String s : cfgInductiveItemIds) {
            b = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s.trim()));
            if (b == null) continue;
            inductiveItems.add((Item)b);
        }
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        if (!enableRedstonePower) {
            return;
        }
        if (!event.getWorld().field_72995_K && !this.worldTrackers.containsKey(event.getWorld())) {
            IEnergyWorldTracker ewt = blocks.isEmpty() || event.getWorld().func_72800_K() != 256 || disableOptimizations ? new EnergyWorldTrackerEveryone(event.getWorld()) : new EnergyWorldTrackerListBased(event.getWorld());
            ewt.register();
            this.worldTrackers.put(event.getWorld(), ewt);
        }
    }

    @SubscribeEvent
    public void onLoadChunk(ChunkEvent.Load event) {
        IEnergyWorldTracker ewt = this.worldTrackers.get(event.getWorld());
        if (ewt != null) {
            ewt.chunkLoaded(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onUnloadChunk(ChunkEvent.Unload event) {
        IEnergyWorldTracker ewt = this.worldTrackers.get(event.getWorld());
        if (ewt != null) {
            ewt.chunkUnloaded(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        IEnergyWorldTracker ewt;
        if (event.phase == TickEvent.Phase.END && (ewt = this.worldTrackers.get(event.world)) != null) {
            ewt.tick();
        }
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        if (this.worldTrackers.containsKey(event.getWorld())) {
            IEnergyWorldTracker ewt = this.worldTrackers.remove(event.getWorld());
            ewt.unregister();
        }
    }

    static {
        powerRamp = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f};
        powerRampItemCharging = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f};
        blocks = Sets.newIdentityHashSet();
        inductiveItems = Sets.newIdentityHashSet();
        tickGrouping = 1;
        cfgBlockIds = new String[0];
        cfgInductiveItemIds = new String[0];
    }
}

