/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.redstoneminus;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import pl.asie.redstoneminus.IEnergyWorldTracker;
import pl.asie.redstoneminus.PowerTicker;
import pl.asie.redstoneminus.RedstoneMinusHelpers;
import pl.asie.redstoneminus.RedstoneMinusRedstone;

public class EnergyWorldTrackerListBased
implements IEnergyWorldTracker,
IWorldEventListener {
    private final PowerTicker ticker = new PowerTicker();
    private final World world;
    private final Map<ChunkPos, Set<BlockPos>> positions = new HashMap<ChunkPos, Set<BlockPos>>();
    private boolean added;

    public EnergyWorldTrackerListBased(World world) {
        this.world = world;
    }

    @Override
    public void register() {
        if (!this.added) {
            this.world.func_72954_a((IWorldEventListener)this);
            this.added = true;
        }
    }

    @Override
    public void unregister() {
        if (this.added) {
            this.added = false;
            this.world.func_72848_b((IWorldEventListener)this);
        }
    }

    @Override
    public void chunkLoaded(Chunk chunk) {
        int startX = chunk.field_76635_g << 4;
        int startZ = chunk.field_76647_h << 4;
        int endX = startX + 15;
        int endZ = startZ + 15;
        int startY = 0;
        int endY = 255;
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (BlockPos pos : BlockPos.func_191531_b((int)startX, (int)startY, (int)startZ, (int)endX, (int)endY, (int)endZ)) {
            IBlockState newState = chunk.func_177435_g(pos);
            if (!RedstoneMinusRedstone.blocks.contains(newState.func_177230_c())) continue;
            set.add(pos.func_185334_h());
        }
        if (set.isEmpty()) {
            this.positions.remove(chunk.func_76632_l());
        } else {
            this.positions.put(chunk.func_76632_l(), set);
        }
    }

    @Override
    public void chunkUnloaded(Chunk chunk) {
        this.positions.remove(chunk.func_76632_l());
    }

    @Override
    public void tick() {
        int[] ramp = this.ticker.tickRamp(RedstoneMinusRedstone.powerRamp);
        if (ramp == null) {
            return;
        }
        HashSet<ChunkPos> deletedPos = new HashSet<ChunkPos>();
        for (Map.Entry<ChunkPos, Set<BlockPos>> entry : this.positions.entrySet()) {
            ChunkPos chunkPos = entry.getKey();
            Chunk chunk = this.world.func_72863_F().func_186026_b(chunkPos.field_77276_a, chunkPos.field_77275_b);
            if (chunk == null) {
                deletedPos.add(chunkPos);
                continue;
            }
            for (BlockPos pos : entry.getValue()) {
                TileEntity tile = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
                if (tile == null) continue;
                RedstoneMinusHelpers.tick(this.world, tile, ramp);
            }
        }
        for (ChunkPos pos : deletedPos) {
            this.positions.remove(pos);
        }
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (RedstoneMinusRedstone.blocks.contains(newState.func_177230_c())) {
            Set set = this.positions.computeIfAbsent(chunkPos, a -> new HashSet());
            set.add(pos);
        } else {
            Set<BlockPos> set = this.positions.get(chunkPos);
            if (set != null && set.remove(pos) && set.isEmpty()) {
                this.positions.remove(chunkPos);
            }
        }
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean minimiseParticleLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }
}

