/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.well.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AxisAlignedBBRotated
extends AxisAlignedBB {
    @Nonnull
    public final Vec3d centerPos;
    @Nonnull
    public final Vec3d inputRotation;
    public final double rotX;
    public final double rotY;
    public final double rotZ;
    protected final double mxx;
    protected final double mxy;
    protected final double mxz;
    protected final double myx;
    protected final double myy;
    protected final double myz;
    protected final double mzx;
    protected final double mzy;
    protected final double mzz;

    public AxisAlignedBBRotated(@Nonnull AxisAlignedBB parent, @Nonnull Vec3d rotation) {
        super(parent.field_72340_a, parent.field_72338_b, parent.field_72339_c, parent.field_72336_d, parent.field_72337_e, parent.field_72334_f);
        this.centerPos = new Vec3d(this.field_72340_a + (this.field_72336_d - this.field_72340_a) / 2.0, this.field_72338_b + (this.field_72337_e - this.field_72338_b) / 2.0, this.field_72339_c + (this.field_72334_f - this.field_72339_c) / 2.0);
        this.inputRotation = rotation;
        this.rotX = Math.toRadians(MathHelper.func_76138_g((double)(-rotation.field_72450_a)));
        this.rotY = Math.toRadians(MathHelper.func_76138_g((double)(-rotation.field_72448_b)));
        this.rotZ = Math.toRadians(MathHelper.func_76138_g((double)(-rotation.field_72449_c)));
        double cosX = Math.cos(this.rotX);
        double sinX = Math.sin(this.rotX);
        double cosY = Math.cos(this.rotY);
        double sinY = Math.sin(this.rotY);
        double cosZ = Math.cos(this.rotZ);
        double sinZ = Math.sin(this.rotZ);
        this.mxx = cosX * cosY;
        this.mxy = cosX * sinY * sinZ - sinX * cosZ;
        this.mxz = cosX * sinY * cosZ + sinX * sinZ;
        this.myx = sinX * cosY;
        this.myy = sinX * sinY * sinZ + cosX * cosZ;
        this.myz = sinX * sinY * cosZ - cosX * sinZ;
        this.mzx = -sinY;
        this.mzy = cosY * sinZ;
        this.mzz = cosY * cosZ;
    }

    @Nonnull
    public Vec3d rotateVec(@Nonnull Vec3d vec) {
        vec = vec.func_178788_d(this.centerPos);
        double prevX = vec.field_72450_a;
        double prevY = vec.field_72448_b;
        double prevZ = vec.field_72449_c;
        double x = this.mxx * prevX + this.mxy * prevY + this.mxz * prevZ;
        double y = this.myx * prevX + this.myy * prevY + this.myz * prevZ;
        double z = this.mzx * prevX + this.mzy * prevY + this.mzz * prevZ;
        return new Vec3d(x, y, z).func_178787_e(this.centerPos);
    }

    @Nullable
    public RayTraceResult func_72327_a(@Nonnull Vec3d vecA, @Nonnull Vec3d vecB) {
        RayTraceResult result = super.func_72327_a(this.rotateVec(vecA), this.rotateVec(vecB));
        if (result == null) {
            return null;
        }
        float fixedX = (float)((double)result.field_178784_b.func_82601_c() - this.rotX * 2.0 / Math.PI);
        float fixedY = (float)((double)result.field_178784_b.func_96559_d() - this.rotY * 2.0 / Math.PI);
        float fixedZ = (float)((double)result.field_178784_b.func_82599_e() - this.rotZ * 2.0 / Math.PI);
        result.field_178784_b = EnumFacing.func_176737_a((float)fixedX, (float)fixedY, (float)fixedZ);
        return result;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Vec3d func_189972_c() {
        return this.centerPos;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AxisAlignedBBRotated other = (AxisAlignedBBRotated)((Object)o);
        if (Double.compare(other.rotX, this.rotX) != 0) {
            return false;
        }
        if (Double.compare(other.rotY, this.rotY) != 0) {
            return false;
        }
        return Double.compare(other.rotZ, this.rotZ) == 0;
    }

    public int hashCode() {
        int result = super.hashCode();
        long bits = Double.doubleToLongBits(this.rotX);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.rotY);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.rotZ);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

