/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.well.common.tileentity;

import git.jbredwards.well.common.config.ConfigHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityWell
extends TileEntity
implements ITickable {
    @Nonnull
    public final FluidTankSynced tank = new FluidTankSynced(this, ConfigHandler.tankCapacity);
    public long fillTick = 0L;
    public int nearbyWells = 1;
    public int delayUntilNextBucket = 0;
    public boolean initialized;
    protected Biome biome;

    public void func_73660_a() {
        if (!this.initialized) {
            this.onLoad();
        }
        if (this.delayUntilNextBucket > 0) {
            --this.delayUntilNextBucket;
        }
        if (this.initialized && this.func_145830_o() && !this.field_145850_b.field_72995_K && this.fillTick <= this.field_145850_b.func_82737_E() && ConfigHandler.canGenerateFluid(this.nearbyWells)) {
            FluidStack fluidToFill = this.getFluidToFill();
            if (fluidToFill != null) {
                this.tank.fill(fluidToFill, true);
            }
            this.initFillTick();
        }
    }

    public void onLoad() {
        if (!this.initialized) {
            this.initialized = true;
            if (!this.field_145850_b.field_72995_K) {
                this.initFillTick();
                this.countNearbyWells(te -> {
                    ++te.nearbyWells;
                    ++this.nearbyWells;
                });
            }
        }
        if (this.tank.updateLight(this.tank.getFluid())) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    @Nullable
    protected FluidStack getFluidToFill() {
        return ConfigHandler.getFillFluid(this.getBiome(), this.field_145850_b, this.isUpsideDown(), this.nearbyWells);
    }

    protected void initFillTick() {
        this.fillTick = this.field_145850_b.func_82737_E() + (long)ConfigHandler.getFillDelay(this.getBiome(), this.field_145850_b.field_73012_v, this.isUpsideDown());
    }

    public void countNearbyWells(@Nonnull Consumer<TileEntityWell> updateScript) {
        BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-15, -15, -15), (BlockPos)this.field_174879_c.func_177982_a(15, 15, 15)).forEach(otherPos -> {
            TileEntity tile;
            if (!otherPos.equals((Object)this.field_174879_c) && this.field_145850_b.func_180494_b(otherPos) == this.getBiome() && (tile = this.field_145850_b.func_175625_s(otherPos)) instanceof TileEntityWell && TileEntityWell.isUpsideDown(tile) == this.isUpsideDown()) {
                updateScript.accept((TileEntityWell)tile);
            }
        });
    }

    public boolean isUpsideDown() {
        return (this.func_145832_p() >> 1 & 1) == 1;
    }

    public static boolean isUpsideDown(@Nonnull TileEntity tile) {
        return tile instanceof TileEntityWell && ((TileEntityWell)tile).isUpsideDown();
    }

    public void func_70296_d() {
        if (this.func_145830_o()) {
            this.biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        }
        super.func_70296_d();
    }

    @Nonnull
    public Biome getBiome() {
        return this.biome == null ? (this.biome = this.field_145850_b.func_180494_b(this.field_174879_c)) : this.biome;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        boolean wasFull;
        FluidStack oldFluid = this.tank.getFluid();
        this.handleUpdateTag(pkt.func_148857_g());
        FluidStack newFluid = this.tank.getFluid();
        boolean wasEmpty = newFluid != null && oldFluid == null;
        boolean bl = wasFull = newFluid == null && oldFluid != null;
        if (wasEmpty || wasFull || newFluid != null && newFluid.amount != oldFluid.amount) {
            if (newFluid != null) {
                this.tank.updateLight(newFluid);
            } else {
                this.tank.updateLight(oldFluid);
            }
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public void func_145839_a(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.fillTick = tag.func_74763_f("fillTick");
        this.initialized = tag.func_74767_n("initialized");
        this.nearbyWells = Math.max(1, tag.func_74762_e("nearbyWells"));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        tag.func_74772_a("fillTick", this.fillTick);
        tag.func_74757_a("initialized", this.initialized);
        tag.func_74768_a("nearbyWells", this.nearbyWells);
        return tag;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public static class FluidTankSynced
    extends FluidTank {
        public FluidTankSynced(@Nonnull TileEntity tile, int capacity) {
            super(capacity);
            this.setTileEntity(tile);
        }

        public boolean canFillFluidType(@Nonnull FluidStack fluid) {
            if (TileEntityWell.isUpsideDown(this.tile) ? !fluid.getFluid().isLighterThanAir() : fluid.getFluid().isLighterThanAir()) {
                return false;
            }
            if (this.tile.func_145831_w().field_73011_w.func_177500_n() && fluid.getFluid().doesVaporize(fluid)) {
                return false;
            }
            return this.canFill();
        }

        public int fillInternal(@Nullable FluidStack resource, boolean doFill) {
            int fill = super.fillInternal(resource, doFill);
            if (doFill && fill > 0) {
                IBlockState state = this.tile.func_145838_q().func_176223_P();
                this.tile.func_145831_w().func_184138_a(this.tile.func_174877_v(), state, state, 3);
                this.updateLight(resource);
            }
            return fill;
        }

        @Nullable
        public FluidStack drainInternal(int maxDrain, boolean doDrain) {
            if (((TileEntityWell)this.tile).delayUntilNextBucket > 0) {
                return null;
            }
            FluidStack resource = super.drainInternal(maxDrain, doDrain);
            if (resource != null && doDrain) {
                IBlockState state = this.tile.func_145838_q().func_176223_P();
                this.tile.func_145831_w().func_184138_a(this.tile.func_174877_v(), state, state, 3);
                this.updateLight(resource);
            }
            return resource;
        }

        protected boolean updateLight(@Nullable FluidStack resource) {
            if (resource != null && resource.getFluid().canBePlacedInWorld() && resource.getFluid().getBlock().func_176223_P().getLightValue((IBlockAccess)this.tile.func_145831_w(), this.tile.func_174877_v()) > 0) {
                return this.tile.func_145831_w().func_175664_x(this.tile.func_174877_v());
            }
            return false;
        }
    }
}

