/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.well.common.init;

import git.jbredwards.well.client.block.model.ModelWellFluid;
import git.jbredwards.well.common.block.BlockWell;
import git.jbredwards.well.common.init.ModBlocks;
import git.jbredwards.well.common.init.ModItems;
import git.jbredwards.well.common.init.ModSounds;
import git.jbredwards.well.common.tileentity.TileEntityWell;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="well")
public final class RegistryHandler {
    @SubscribeEvent
    static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        ModBlocks.INIT.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        TileEntity.func_190560_a((String)"well:well", TileEntityWell.class);
    }

    @SubscribeEvent
    static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        ModItems.INIT.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        ModItems.INIT.forEach(item -> OreDictionary.registerOre((String)"blockWell", (Item)item));
    }

    @SubscribeEvent
    static void registerSounds(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModSounds.CRANK);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    static void registerModels(@Nonnull ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelWellFluid.Loader.INSTANCE);
        ModItems.INIT.forEach(item -> ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory")));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    static void registerBlockColors(@Nonnull ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
            FluidStack fluid;
            TileEntity tile;
            if (world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof TileEntityWell && (fluid = ((TileEntityWell)tile).tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld()) {
                return event.getBlockColors().func_186724_a(fluid.getFluid().getBlock().func_176223_P(), world, pos, tintIndex);
            }
            return -1;
        }, (Block[])ModBlocks.INIT.toArray(new BlockWell[0]));
    }
}

