/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.well.common.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="well")
@Mod.EventBusSubscriber(modid="well")
public final class ConfigHandler {
    @Config.RangeInt(min=0)
    @Config.RequiresWorldRestart
    @Config.LangKey(value="config.well.tankCapacity")
    public static int tankCapacity = 100000;
    @Config.LangKey(value="config.well.onlyOnePerChunk")
    public static boolean onlyOnePerChunk = false;
    @Config.LangKey(value="config.well.playSound")
    public static boolean playSound = true;
    @Config.LangKey(value="config.well.data")
    @Nonnull
    public static String data = "{}";
    @Nonnull
    static final Map<Biome, WellFluidData> downWellData = new HashMap<Biome, WellFluidData>();
    @Nonnull
    static final Map<Biome, WellFluidData> upWellData = new HashMap<Biome, WellFluidData>();

    public static float getRenderedFluidHeight(@Nonnull FluidStack fluid, boolean isUpsideDown) {
        float normalHeight = (float)fluid.amount * 14.0f / (float)(16 * tankCapacity) + 0.125f;
        return isUpsideDown ? 1.0f - normalHeight : normalHeight;
    }

    public static boolean canGenerateFluid(int nearbyWells) {
        return !onlyOnePerChunk || nearbyWells == 1;
    }

    public static void initData() {
        WellFluidData.DOWN_DEFAULT.reset();
        WellFluidData.UP_DEFAULT.reset();
        downWellData.clear();
        upWellData.clear();
        try {
            FluidStack defaultFluid;
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)data);
            if (nbt.func_150297_b("DefaultFluid", 10) && (defaultFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("DefaultFluid"))) != null) {
                WellFluidData.DOWN_DEFAULT.fluid = defaultFluid;
                WellFluidData.UP_DEFAULT.fluid = defaultFluid;
            }
            if (nbt.func_150297_b("DefaultMinTicks", 3)) {
                WellFluidData.DOWN_DEFAULT.minToFill = Math.max(0, nbt.func_74762_e("DefaultMinTicks"));
                WellFluidData.UP_DEFAULT.minToFill = Math.max(0, nbt.func_74762_e("DefaultMinTicks"));
            }
            if (nbt.func_150297_b("DefaultMaxTicks", 3)) {
                WellFluidData.DOWN_DEFAULT.maxToFill = Math.max(0, nbt.func_74762_e("DefaultMaxTicks"));
                WellFluidData.UP_DEFAULT.maxToFill = Math.max(0, nbt.func_74762_e("DefaultMaxTicks"));
            }
            if (nbt.func_150297_b("DefaultDownFluid", 10) && (defaultFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("DefaultDownFluid"))) != null) {
                WellFluidData.DOWN_DEFAULT.fluid = defaultFluid;
            }
            if (nbt.func_150297_b("DefaultDownMinTicks", 3)) {
                WellFluidData.DOWN_DEFAULT.minToFill = Math.max(0, nbt.func_74762_e("DefaultDownMinTicks"));
            }
            if (nbt.func_150297_b("DefaultDownMaxTicks", 3)) {
                WellFluidData.DOWN_DEFAULT.maxToFill = Math.max(0, nbt.func_74762_e("DefaultDownMaxTicks"));
            }
            if (nbt.func_150297_b("DefaultUpFluid", 10) && (defaultFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("DefaultUpFluid"))) != null) {
                WellFluidData.UP_DEFAULT.fluid = defaultFluid;
            }
            if (nbt.func_150297_b("DefaultUpMinTicks", 3)) {
                WellFluidData.UP_DEFAULT.minToFill = Math.max(0, nbt.func_74762_e("DefaultUpMinTicks"));
            }
            if (nbt.func_150297_b("DefaultUpMaxTicks", 3)) {
                WellFluidData.UP_DEFAULT.maxToFill = Math.max(0, nbt.func_74762_e("DefaultUpMaxTicks"));
            }
            if (nbt.func_150297_b("Data", 9)) {
                NBTTagList dataList = nbt.func_150295_c("Data", 10);
                for (int i = 0; i < dataList.func_74745_c(); ++i) {
                    int minToFill;
                    boolean isUpsideDown;
                    NBTTagCompound data = dataList.func_150305_b(i);
                    if (!data.func_150297_b("Fluid", 10)) continue;
                    FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("Fluid"));
                    boolean bl = isUpsideDown = fluid != null && fluid.getFluid().isLighterThanAir();
                    int n = fluid != null && data.func_150297_b("MinTicks", 3) ? Math.abs(data.func_74762_e("MinTicks")) : (minToFill = (isUpsideDown ? WellFluidData.UP_DEFAULT : WellFluidData.DOWN_DEFAULT).minToFill);
                    int maxToFill = fluid != null && data.func_150297_b("MaxTicks", 3) ? Math.abs(data.func_74762_e("MaxTicks")) : (isUpsideDown ? WellFluidData.UP_DEFAULT : WellFluidData.DOWN_DEFAULT).maxToFill;
                    WellFluidData wellData = new WellFluidData(fluid, minToFill, maxToFill);
                    data.func_150295_c("BiomeTags", 8).forEach(biomeTagNbt -> {
                        BiomeDictionary.Type biomeTag = BiomeDictionary.Type.getType((String)((NBTTagString)biomeTagNbt).func_150285_a_(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                        for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeTag)) {
                            if (fluid == null || maxToFill < minToFill || maxToFill <= 0) {
                                downWellData.remove(biome);
                                upWellData.remove(biome);
                                continue;
                            }
                            if (isUpsideDown) {
                                upWellData.put(biome, wellData);
                                continue;
                            }
                            downWellData.put(biome, wellData);
                        }
                    });
                    data.func_150295_c("Biomes", 8).forEach(biomeNbt -> {
                        Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(((NBTTagString)biomeNbt).func_150285_a_()));
                        if (biome != null) {
                            if (fluid == null || maxToFill < minToFill || maxToFill <= 0) {
                                downWellData.remove(biome);
                                upWellData.remove(biome);
                            } else if (isUpsideDown) {
                                upWellData.put(biome, wellData);
                            } else {
                                downWellData.put(biome, wellData);
                            }
                        }
                    });
                }
            }
        }
        catch (NBTException nBTException) {
            // empty catch block
        }
    }

    @Nullable
    public static FluidStack getFillFluid(@Nonnull Biome biome, @Nonnull World world, boolean upsideDown, int nearbyWells) {
        WellFluidData data;
        WellFluidData wellFluidData = data = upsideDown ? upWellData.getOrDefault(biome, WellFluidData.UP_DEFAULT) : downWellData.getOrDefault(biome, WellFluidData.DOWN_DEFAULT);
        if (data.fluid.amount <= 0 || world.field_73011_w.func_177500_n() && data.fluid.getFluid().doesVaporize(data.fluid)) {
            return null;
        }
        FluidStack fluid = data.fluid.copy();
        fluid.amount /= nearbyWells;
        return fluid;
    }

    public static int getFillDelay(@Nonnull Biome biome, @Nonnull Random rand, boolean upsideDown) {
        WellFluidData data = upsideDown ? upWellData.getOrDefault(biome, WellFluidData.UP_DEFAULT) : downWellData.getOrDefault(biome, WellFluidData.DOWN_DEFAULT);
        return MathHelper.func_76136_a((Random)rand, (int)data.minToFill, (int)data.maxToFill);
    }

    @SubscribeEvent
    static void sync(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("well")) {
            ConfigManager.sync((String)"well", (Config.Type)Config.Type.INSTANCE);
            ConfigHandler.initData();
        }
    }

    static class WellFluidData {
        @Nonnull
        static final WellFluidData DOWN_DEFAULT = new WellFluidData(new FluidStack(FluidRegistry.WATER, 1000), 160, 200);
        @Nonnull
        static final WellFluidData UP_DEFAULT = new WellFluidData(new FluidStack(FluidRegistry.WATER, 1000), 160, 200);
        FluidStack fluid;
        int minToFill;
        int maxToFill;

        WellFluidData(@Nullable FluidStack fluidIn, int minIn, int maxIn) {
            this.fluid = fluidIn;
            this.minToFill = minIn;
            this.maxToFill = maxIn;
        }

        void reset() {
            this.fluid = new FluidStack(FluidRegistry.WATER, 1000);
            this.minToFill = 160;
            this.maxToFill = 200;
        }
    }
}

