/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.well.common.block;

import com.google.common.collect.ImmutableList;
import git.jbredwards.well.common.block.BlockWell;
import git.jbredwards.well.common.util.AxisAlignedBBRotated;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public final class WellCollisions {
    @Nonnull
    public static final List<AxisAlignedBB> BOTTOM_BB = ImmutableList.of((Object)WellCollisions.box(0.0, 0.0, 0.0, 3.0, 16.0, 16.0), (Object)WellCollisions.box(13.0, 0.0, 0.0, 16.0, 16.0, 16.0), (Object)WellCollisions.box(0.0, 0.0, 0.0, 16.0, 16.0, 3.0), (Object)WellCollisions.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), (Object)WellCollisions.box(3.0, 0.0, 3.0, 10.0, 1.0, 10.0));
    @Nonnull
    public static final List<AxisAlignedBB> TOP_TRACE_BB_X = ImmutableList.of((Object)WellCollisions.box(7.5, 0.0, 14.0, 8.5, 15.0, 15.0), (Object)WellCollisions.box(7.5, 7.0, 2.0, 8.5, 8.0, 14.0), (Object)WellCollisions.box(5.0, 4.5, 4.5, 11.0, 10.5, 11.5), (Object)WellCollisions.box(7.5, 0.0, 1.0, 8.5, 15.0, 2.0), (Object)WellCollisions.box(7.3, 15.0, 0.0, 8.7, 15.7, 16.0), (Object)((Object)new AxisAlignedBBRotated(WellCollisions.box(6.9, 11.3, 0.0, 16.9, 12.3, 16.0), new Vec3d(-45.0, 0.0, 0.0))), (Object)((Object)new AxisAlignedBBRotated(WellCollisions.box(-0.9, 11.3, 0.0, 9.1, 12.3, 16.0), new Vec3d(45.0, 0.0, 0.0))));
    @Nonnull
    public static final List<AxisAlignedBB> TOP_COLLIDE_BB_X = ImmutableList.of((Object)WellCollisions.box(7.5, 0.0, 14.0, 8.5, 15.0, 15.0), (Object)WellCollisions.box(7.5, 7.0, 2.0, 8.5, 8.0, 14.0), (Object)WellCollisions.box(5.0, 4.5, 4.5, 11.0, 10.5, 11.5), (Object)WellCollisions.box(7.5, 0.0, 1.0, 8.5, 15.0, 2.0), (Object)WellCollisions.box(7.3, 15.0, 0.0, 8.7, 15.7, 16.0), (Object)WellCollisions.box(7.0, 14.0, 0.0, 8.0, 15.0, 16.0), (Object)WellCollisions.box(6.0, 13.0, 0.0, 7.0, 14.0, 16.0), (Object)WellCollisions.box(5.0, 12.0, 0.0, 6.0, 13.0, 16.0), (Object)WellCollisions.box(4.0, 11.0, 0.0, 5.0, 12.0, 16.0), (Object)WellCollisions.box(3.0, 10.0, 0.0, 4.0, 11.0, 16.0), (Object)WellCollisions.box(2.0, 9.0, 0.0, 3.0, 10.0, 16.0), (Object)WellCollisions.box(1.0, 8.0, 0.0, 2.0, 9.0, 16.0), (Object[])new AxisAlignedBB[]{WellCollisions.box(0.0, 7.0, 0.0, 1.0, 8.0, 16.0), WellCollisions.box(8.0, 14.0, 0.0, 9.0, 15.0, 16.0), WellCollisions.box(9.0, 13.0, 0.0, 10.0, 14.0, 16.0), WellCollisions.box(10.0, 12.0, 0.0, 11.0, 13.0, 16.0), WellCollisions.box(11.0, 11.0, 0.0, 12.0, 12.0, 16.0), WellCollisions.box(12.0, 10.0, 0.0, 13.0, 11.0, 16.0), WellCollisions.box(13.0, 9.0, 0.0, 14.0, 10.0, 16.0), WellCollisions.box(14.0, 8.0, 0.0, 15.0, 9.0, 16.0), WellCollisions.box(15.0, 7.0, 0.0, 16.0, 8.0, 16.0)});
    @Nonnull
    public static final List<AxisAlignedBB> TOP_TRACE_BB_Z = ImmutableList.of((Object)WellCollisions.box(14.0, 0.0, 7.5, 15.0, 15.0, 8.5), (Object)WellCollisions.box(2.0, 7.0, 7.5, 14.0, 8.0, 8.5), (Object)WellCollisions.box(4.5, 4.5, 5.0, 11.5, 10.5, 11.0), (Object)WellCollisions.box(1.0, 0.0, 7.5, 2.0, 15.0, 8.5), (Object)WellCollisions.box(0.0, 15.0, 7.3, 16.0, 15.7, 8.7), (Object)((Object)new AxisAlignedBBRotated(WellCollisions.box(0.0, 11.3, 6.9, 16.0, 12.3, 16.9), new Vec3d(0.0, 0.0, 45.0))), (Object)((Object)new AxisAlignedBBRotated(WellCollisions.box(0.0, 11.3, -0.9, 16.0, 12.3, 9.1), new Vec3d(0.0, 0.0, -45.0))));
    @Nonnull
    public static final List<AxisAlignedBB> TOP_COLLIDE_BB_Z = ImmutableList.of((Object)WellCollisions.box(14.0, 0.0, 7.5, 15.0, 15.0, 8.5), (Object)WellCollisions.box(2.0, 7.0, 7.5, 14.0, 8.0, 8.5), (Object)WellCollisions.box(4.5, 4.5, 5.0, 11.5, 10.5, 11.0), (Object)WellCollisions.box(1.0, 0.0, 7.5, 2.0, 15.0, 8.5), (Object)WellCollisions.box(0.0, 15.0, 7.3, 16.0, 15.7, 8.7), (Object)WellCollisions.box(0.0, 14.0, 7.0, 16.0, 15.0, 8.0), (Object)WellCollisions.box(0.0, 13.0, 6.0, 16.0, 14.0, 7.0), (Object)WellCollisions.box(0.0, 12.0, 5.0, 16.0, 13.0, 6.0), (Object)WellCollisions.box(0.0, 11.0, 4.0, 16.0, 12.0, 5.0), (Object)WellCollisions.box(0.0, 10.0, 3.0, 16.0, 11.0, 4.0), (Object)WellCollisions.box(0.0, 9.0, 2.0, 16.0, 10.0, 3.0), (Object)WellCollisions.box(0.0, 8.0, 1.0, 16.0, 9.0, 2.0), (Object[])new AxisAlignedBB[]{WellCollisions.box(0.0, 7.0, 0.0, 16.0, 8.0, 1.0), WellCollisions.box(0.0, 14.0, 8.0, 16.0, 15.0, 9.0), WellCollisions.box(0.0, 13.0, 9.0, 16.0, 14.0, 10.0), WellCollisions.box(0.0, 12.0, 10.0, 16.0, 13.0, 11.0), WellCollisions.box(0.0, 11.0, 11.0, 16.0, 12.0, 12.0), WellCollisions.box(0.0, 10.0, 12.0, 16.0, 11.0, 13.0), WellCollisions.box(0.0, 9.0, 13.0, 16.0, 10.0, 14.0), WellCollisions.box(0.0, 8.0, 14.0, 16.0, 9.0, 15.0), WellCollisions.box(0.0, 7.0, 15.0, 16.0, 8.0, 16.0)});
    @Nonnull
    public static final List<AxisAlignedBB> BOTTOM_BB_FLIPPED = WellCollisions.flip(BOTTOM_BB);
    @Nonnull
    public static final List<AxisAlignedBB> TOP_TRACE_BB_X_FLIPPED = WellCollisions.flip(TOP_TRACE_BB_X);
    @Nonnull
    public static final List<AxisAlignedBB> TOP_COLLIDE_BB_X_FLIPPED = WellCollisions.flip(TOP_COLLIDE_BB_X);
    @Nonnull
    public static final List<AxisAlignedBB> TOP_TRACE_BB_Z_FLIPPED = WellCollisions.flip(TOP_TRACE_BB_Z);
    @Nonnull
    public static final List<AxisAlignedBB> TOP_COLLIDE_BB_Z_FLIPPED = WellCollisions.flip(TOP_COLLIDE_BB_Z);

    @Nonnull
    public static List<AxisAlignedBB> getTraceBoxList(@Nonnull IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BlockWell.UPSIDE_DOWN)).booleanValue()) {
            return (Boolean)state.func_177229_b((IProperty)BlockWell.IS_BOTTOM) != false ? BOTTOM_BB_FLIPPED : (state.func_177229_b(BlockWell.AXIS) == EnumFacing.Axis.X ? TOP_TRACE_BB_X_FLIPPED : TOP_TRACE_BB_Z_FLIPPED);
        }
        return (Boolean)state.func_177229_b((IProperty)BlockWell.IS_BOTTOM) != false ? BOTTOM_BB : (state.func_177229_b(BlockWell.AXIS) == EnumFacing.Axis.X ? TOP_TRACE_BB_X : TOP_TRACE_BB_Z);
    }

    @Nonnull
    public static List<AxisAlignedBB> getCollisionBoxList(@Nonnull IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BlockWell.UPSIDE_DOWN)).booleanValue()) {
            return (Boolean)state.func_177229_b((IProperty)BlockWell.IS_BOTTOM) != false ? BOTTOM_BB_FLIPPED : (state.func_177229_b(BlockWell.AXIS) == EnumFacing.Axis.X ? TOP_COLLIDE_BB_X_FLIPPED : TOP_COLLIDE_BB_Z_FLIPPED);
        }
        return (Boolean)state.func_177229_b((IProperty)BlockWell.IS_BOTTOM) != false ? BOTTOM_BB : (state.func_177229_b(BlockWell.AXIS) == EnumFacing.Axis.X ? TOP_COLLIDE_BB_X : TOP_COLLIDE_BB_Z);
    }

    @Nonnull
    static AxisAlignedBB box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new AxisAlignedBB(minX / 16.0, minY / 16.0, minZ / 16.0, maxX / 16.0, maxY / 16.0, maxZ / 16.0);
    }

    @Nonnull
    static List<AxisAlignedBB> flip(@Nonnull List<AxisAlignedBB> list) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AxisAlignedBB aabb : list) {
            AxisAlignedBB newBB = new AxisAlignedBB(aabb.field_72340_a, 1.0 - aabb.field_72337_e, aabb.field_72339_c, aabb.field_72336_d, 1.0 - aabb.field_72338_b, aabb.field_72334_f);
            if (aabb instanceof AxisAlignedBBRotated) {
                Vec3d rot = ((AxisAlignedBBRotated)aabb).inputRotation;
                builder.add((Object)new AxisAlignedBBRotated(newBB, new Vec3d(-rot.field_72450_a, -rot.field_72448_b, -rot.field_72449_c)));
                continue;
            }
            builder.add((Object)newBB);
        }
        return builder.build();
    }
}

