/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.well.common.block;

import git.jbredwards.well.common.block.FluidUnlistedProperty;
import git.jbredwards.well.common.block.WellCollisions;
import git.jbredwards.well.common.config.ConfigHandler;
import git.jbredwards.well.common.init.ModSounds;
import git.jbredwards.well.common.tileentity.TileEntityWell;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWell
extends Block
implements ITileEntityProvider {
    @Nonnull
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177708_a((String)"axis", EnumFacing.Axis.class, EnumFacing.Axis::func_176722_c);
    @Nonnull
    public static final PropertyBool IS_BOTTOM = PropertyBool.func_177716_a((String)"is_bottom");
    @Nonnull
    public static final PropertyBool UPSIDE_DOWN = PropertyBool.func_177716_a((String)"upside_down");
    @Nullable
    protected FluidStack cachedFluid;

    public BlockWell(@Nonnull Material materialIn) {
        this(materialIn, materialIn.func_151565_r());
    }

    public BlockWell(@Nonnull Material materialIn, @Nonnull MapColor mapColorIn) {
        super(materialIn, mapColorIn);
        this.func_149647_a(CreativeTabs.field_78031_c).func_149711_c(3.0f).func_149752_b(1.5f).setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IS_BOTTOM, (Comparable)Boolean.valueOf(true)));
        this.field_149783_u = true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{FluidUnlistedProperty.INSTANCE}).add(new IProperty[]{AXIS, IS_BOTTOM, UPSIDE_DOWN}).build();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IS_BOTTOM, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)UPSIDE_DOWN, (Comparable)Boolean.valueOf((meta >> 1 & 1) == 1)).func_177226_a(AXIS, (Comparable)EnumFacing.func_176737_a((float)(meta >> 2 & 1 ^ 1), (float)0.0f, (float)(meta >> 2 & 1)).func_176740_k());
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)IS_BOTTOM) != false ? 1 : 0) | ((Boolean)state.func_177229_b((IProperty)UPSIDE_DOWN) != false ? 2 : 0) | ((EnumFacing.Axis)state.func_177229_b(AXIS)).ordinal() << 1;
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_BOTTOM);
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileEntityWell();
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return this.hasTileEntity(state) ? this.func_149915_a(world, 0) : null;
    }

    public boolean func_176196_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && (super.func_176196_c(worldIn, pos.func_177984_a()) || super.func_176196_c(worldIn, pos.func_177977_b()));
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        EnumFacing.Axis axis = placer.func_70093_af() ? placer.func_174811_aO().func_176746_e().func_176740_k() : placer.func_174811_aO().func_176740_k();
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)axis).func_177226_a((IProperty)UPSIDE_DOWN, (Comparable)Boolean.valueOf(!super.func_176196_c(worldIn, pos.func_177984_a())));
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity tile;
        int verticalDir = (Boolean)state.func_177229_b((IProperty)UPSIDE_DOWN) != false ? -1 : 1;
        worldIn.func_180501_a(pos.func_177981_b(verticalDir), state.func_177226_a((IProperty)IS_BOTTOM, (Comparable)Boolean.valueOf(false)), 2);
        if (ConfigHandler.onlyOnePerChunk && placer instanceof EntityPlayerMP && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityWell && ((TileEntityWell)tile).nearbyWells > 1) {
            this.sendWarning((EntityPlayerMP)placer, verticalDir == -1);
        }
    }

    protected void sendWarning(@Nonnull EntityPlayerMP player, boolean isUpsideDown) {
        player.field_71135_a.func_147359_a((Packet)new SPacketTitle(SPacketTitle.Type.ACTIONBAR, (ITextComponent)new TextComponentTranslation(isUpsideDown ? "warn.well.onePerChunkFlipped" : "warn.well.onePerChunk", new Object[0])));
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityWell) {
            ((TileEntityWell)tile).countNearbyWells(te -> --te.nearbyWells);
            worldIn.func_175713_t(pos);
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        int verticalDir;
        int n = verticalDir = (Boolean)state.func_177229_b((IProperty)UPSIDE_DOWN) != false ? -1 : 1;
        if (pos.equals((Object)fromPos.func_177979_c(verticalDir)) && ((Boolean)state.func_177229_b((IProperty)IS_BOTTOM)).booleanValue() && worldIn.func_180495_p(fromPos).func_177230_c() != this) {
            worldIn.func_175655_b(pos, false);
        } else if (pos.equals((Object)fromPos.func_177981_b(verticalDir)) && !((Boolean)state.func_177229_b((IProperty)IS_BOTTOM)).booleanValue() && worldIn.func_180495_p(fromPos).func_177230_c() != this) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityWell && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            boolean changed;
            TileEntityWell well = (TileEntityWell)tile;
            int prevAmount = well.tank.getFluidAmount();
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            boolean bl = changed = handler != null && FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (IFluidHandler)handler);
            if (changed) {
                if (ConfigHandler.playSound && prevAmount > well.tank.getFluidAmount()) {
                    worldIn.func_184133_a(null, pos.func_177984_a(), ModSounds.CRANK, SoundCategory.BLOCKS, 0.25f, 1.0f);
                    ((TileEntityWell)tile).delayUntilNextBucket = 32;
                }
                return true;
            }
        }
        return false;
    }

    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        float baseFluidLight;
        FluidStack fluid;
        TileEntity tile;
        if (((Boolean)state.func_177229_b((IProperty)IS_BOTTOM)).booleanValue() && (tile = world.func_175625_s(pos)) instanceof TileEntityWell && (fluid = ((TileEntityWell)tile).tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld() && (baseFluidLight = (float)fluid.getFluid().getBlock().func_176223_P().func_185906_d()) > 0.0f) {
            if (FMLCommonHandler.instance().getSide().isClient() && this.canRenderFluid()) {
                return Math.max(state.func_185906_d(), (int)baseFluidLight);
            }
            int fluidLight = MathHelper.func_76125_a((int)((int)((double)(baseFluidLight * (float)fluid.amount / (float)ConfigHandler.tankCapacity) + 0.5)), (int)1, (int)15);
            return Math.max(state.func_185906_d(), fluidLight);
        }
        return state.func_185906_d();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        int fluidLight;
        FluidStack fluid;
        TileEntity tile;
        if (this.canRenderFluid() && (tile = source.func_175625_s(pos)) instanceof TileEntityWell && (fluid = ((TileEntityWell)tile).tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld() && (fluidLight = fluid.getFluid().getBlock().func_176223_P().func_185906_d()) > 0) {
            return source.func_175626_b(pos, Math.max(fluidLight, state.func_185906_d()));
        }
        return super.func_185484_c(state, source, pos);
    }

    public void func_185477_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        WellCollisions.getCollisionBoxList(state).forEach(aabb -> BlockWell.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)aabb));
    }

    @Nullable
    public RayTraceResult func_180636_a(@Nonnull IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        RayTraceResult[] collidingBoxes = (RayTraceResult[])WellCollisions.getTraceBoxList(blockState).stream().map(aabb -> this.func_185503_a(pos, start, end, (AxisAlignedBB)aabb)).filter(Objects::nonNull).toArray(RayTraceResult[]::new);
        if (collidingBoxes.length == 0) {
            return null;
        }
        RayTraceResult furthest = null;
        double dist = -1.0;
        for (RayTraceResult trace : collidingBoxes) {
            double newDist = trace.field_72307_f.func_72436_e(end);
            if (!(newDist > dist)) continue;
            furthest = trace;
            dist = newDist;
        }
        return furthest;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        boolean isBottom = state.func_177229_b((IProperty)IS_BOTTOM) != state.func_177229_b((IProperty)UPSIDE_DOWN);
        return new AxisAlignedBB(0.0, isBottom ? 0.0 : -1.0, 0.0, 1.0, isBottom ? 2.0 : 1.0, 1.0).func_186670_a(pos);
    }

    @Nullable
    public Boolean isEntityInsideMaterial(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
        FluidStack fluid;
        TileEntity tile;
        if (!testingHead) {
            yToTest = entity.field_70163_u;
        }
        if ((tile = world.func_175625_s(pos)) instanceof TileEntityWell && (fluid = ((TileEntityWell)tile).tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld() && fluid.getFluid().getBlock().func_176223_P().func_185904_a() == materialIn) {
            return ((Boolean)state.func_177229_b((IProperty)UPSIDE_DOWN)).booleanValue() ? yToTest >= (double)((float)pos.func_177956_o() - ConfigHandler.getRenderedFluidHeight(fluid, true)) : yToTest <= (double)((float)pos.func_177956_o() + ConfigHandler.getRenderedFluidHeight(fluid, false));
        }
        return null;
    }

    @Nullable
    public Boolean isAABBInsideMaterial(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB boundingBox, @Nonnull Material materialIn) {
        FluidStack fluid;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityWell && (fluid = ((TileEntityWell)tile).tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld() && fluid.getFluid().getBlock().func_176223_P().func_185904_a() == materialIn) {
            this.cachedFluid = fluid;
            return this.isAABBInsideLiquid(world, pos, boundingBox);
        }
        return null;
    }

    @Nullable
    public Boolean isAABBInsideLiquid(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB boundingBox) {
        FluidStack fluid;
        TileEntity tile;
        if (this.cachedFluid == null && (tile = world.func_175625_s(pos)) instanceof TileEntityWell && (fluid = ((TileEntityWell)tile).tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld()) {
            this.cachedFluid = fluid;
        }
        FluidStack fluid2 = this.cachedFluid;
        this.cachedFluid = null;
        if (fluid2 == null) {
            return false;
        }
        if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)UPSIDE_DOWN)).booleanValue()) {
            return boundingBox.field_72338_b >= (double)((float)pos.func_177956_o() - ConfigHandler.getRenderedFluidHeight(fluid2, true)) ? Boolean.valueOf(true) : null;
        }
        return boundingBox.field_72338_b <= (double)((float)pos.func_177956_o() + ConfigHandler.getRenderedFluidHeight(fluid2, false)) ? Boolean.valueOf(true) : null;
    }

    public float getBlockLiquidHeight(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Material material) {
        FluidStack fluid;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityWell && (fluid = ((TileEntityWell)tile).tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld() && fluid.getFluid().getBlock().func_176223_P().func_185904_a() == material) {
            return ConfigHandler.getRenderedFluidHeight(fluid, false);
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState stateIn, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        FluidStack fluid;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityWell && (fluid = ((TileEntityWell)tile).tank.getFluid()) != null && fluid.getFluid().canBePlacedInWorld()) {
            float height = ConfigHandler.getRenderedFluidHeight(fluid, false);
            IBlockState fluidState = fluid.getFluid().getBlock().func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(8 - (int)(height * 8.0f)));
            fluidState.func_177230_c().func_180655_c(fluidState, worldIn, pos, rand);
            if (fluid.getFluid() == FluidRegistry.LAVA) {
                double z;
                double y;
                double x;
                if (rand.nextInt(100) == 0) {
                    x = (float)pos.func_177958_n() + rand.nextFloat();
                    y = (float)pos.func_177956_o() + height;
                    z = (float)pos.func_177952_p() + rand.nextFloat();
                    worldIn.func_175688_a(EnumParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_184134_a(x, y, z, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                }
                if (rand.nextInt(200) == 0) {
                    x = (double)pos.func_177958_n() + 0.5;
                    y = (float)pos.func_177956_o() + height / 2.0f;
                    z = (double)pos.func_177952_p() + 0.5;
                    worldIn.func_184134_a(x, y, z, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                }
            }
        }
    }

    @Nonnull
    public SoundType getSoundType(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        return (Boolean)state.func_177229_b((IProperty)IS_BOTTOM) != false ? this.func_185467_w() : Blocks.field_150336_V.func_185467_w();
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return (Boolean)state.func_177229_b((IProperty)IS_BOTTOM) != false && face != EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return state.func_193401_d(world, pos, side) == BlockFaceShape.SOLID;
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return state.isSideSolid(world, pos, face);
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || (Boolean)state.func_177229_b((IProperty)IS_BOTTOM) != false && layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean canRenderFluid() {
        return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity tile;
        if (state instanceof IExtendedBlockState && (tile = world.func_175625_s(pos)) instanceof TileEntityWell) {
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)FluidUnlistedProperty.INSTANCE, (Object)((TileEntityWell)tile).tank.getFluid());
        }
        return state;
    }
}

