/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.well.client.block.model;

import git.jbredwards.well.common.block.BlockWell;
import git.jbredwards.well.common.block.FluidUnlistedProperty;
import git.jbredwards.well.common.config.ConfigHandler;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum ModelWellFluid implements IModel
{
    INSTANCE;


    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModel(bakedTextureGetter, format);
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }

        public boolean accepts(@Nonnull ResourceLocation modelLocation) {
            return modelLocation.equals((Object)new ResourceLocation("well", "models/block/fluid"));
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return INSTANCE;
        }
    }

    public static class BakedModel
    implements IBakedModel {
        @Nonnull
        protected final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
        @Nonnull
        protected final VertexFormat format;

        public BakedModel(@Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull VertexFormat format) {
            this.bakedTextureGetter = bakedTextureGetter;
            this.format = format;
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            FluidStack fluid;
            if (state instanceof IExtendedBlockState && side == EnumFacing.UP && (fluid = (FluidStack)((IExtendedBlockState)state).getValue((IUnlistedProperty)FluidUnlistedProperty.INSTANCE)) != null) {
                boolean isUpsideDown = (Boolean)state.func_177229_b((IProperty)BlockWell.UPSIDE_DOWN);
                float height = ConfigHandler.getRenderedFluidHeight(fluid, isUpsideDown);
                return Collections.singletonList(ItemTextureQuadConverter.genQuad((VertexFormat)this.format, (TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, height, isUpsideDown ? 1.0f : 0.0f), null, null, new Quat4f(1.0f, 0.0f, 0.0f, isUpsideDown ? -1.0f : 1.0f)), (float)3.0f, (float)3.0f, (float)13.0f, (float)13.0f, (float)0.0f, (TextureAtlasSprite)this.bakedTextureGetter.apply(fluid.getFluid().getStill(fluid)), (EnumFacing)side, (int)fluid.getFluid().getColor(fluid), (int)0));
            }
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public boolean isAmbientOcclusion(@Nonnull IBlockState state) {
            return this.func_177555_b();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.bakedTextureGetter.apply(FluidRegistry.WATER.getStill());
        }
    }
}

