/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.shader;

import extendedrenderer.shader.InstancedMeshParticle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class MeshBufferManagerParticle {
    public static int numInstances = 50000;
    private static HashMap<TextureAtlasSprite, InstancedMeshParticle> lookupParticleToMesh = new HashMap();

    public static void setupMeshForParticle(TextureAtlasSprite sprite) {
        float[] positions = null;
        positions = new float[]{-0.5f, 0.5f, 0.0f, -0.5f, -0.5f, 0.0f, 0.5f, -0.5f, 0.0f, 0.5f, 0.5f, 0.0f};
        float[] texCoords = null;
        texCoords = new float[]{sprite.func_94209_e(), sprite.func_94206_g(), sprite.func_94209_e(), sprite.func_94210_h(), sprite.func_94212_f(), sprite.func_94210_h(), sprite.func_94212_f(), sprite.func_94206_g()};
        int[] indices = new int[]{0, 1, 3, 3, 1, 2};
        InstancedMeshParticle mesh = new InstancedMeshParticle(positions, texCoords, indices, numInstances);
        if (!lookupParticleToMesh.containsKey(sprite)) {
            lookupParticleToMesh.put(sprite, mesh);
        } else {
            System.out.println("WARNING: duplicate entry attempt for particle sprite: " + sprite);
        }
    }

    public static void cleanup() {
        for (Map.Entry<TextureAtlasSprite, InstancedMeshParticle> entry : lookupParticleToMesh.entrySet()) {
            entry.getValue().cleanup();
        }
        lookupParticleToMesh.clear();
    }

    public static InstancedMeshParticle getMesh(TextureAtlasSprite sprite) {
        return lookupParticleToMesh.get(sprite);
    }

    public static void setupMeshForParticleIfMissing(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return;
        }
        if (!lookupParticleToMesh.containsKey(sprite)) {
            MeshBufferManagerParticle.setupMeshForParticle(sprite);
        }
    }
}

