/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.behavior;

import CoroUtil.util.Vec3;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.particle.entity.ParticleTexFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleBehaviors {
    public List<EntityRotFX> particles = new ArrayList<EntityRotFX>();
    public Vec3 coordSource;
    public Entity sourceEntity = null;
    public Random rand = new Random();
    public float rateDarken = 0.025f;
    public float rateBrighten = 0.01f;
    public float rateBrightenSlower = 0.003f;
    public float rateAlpha = 0.002f;
    public float rateScale = 0.1f;
    public int tickSmokifyTrigger = 40;

    public ParticleBehaviors(Vec3 source) {
        this.coordSource = source;
    }

    public void tickUpdateList() {
        for (int i = 0; i < this.particles.size(); ++i) {
            EntityRotFX particle = this.particles.get(i);
            if (!particle.func_187113_k()) {
                this.particles.remove(particle);
                continue;
            }
            this.tickUpdate(particle);
        }
    }

    public void tickUpdate(EntityRotFX particle) {
        if (this.sourceEntity != null) {
            this.coordSource = new Vec3(this.sourceEntity.field_70165_t, this.sourceEntity.field_70163_u, this.sourceEntity.field_70161_v);
        }
        this.tickUpdateAct(particle);
    }

    public void tickUpdateAct(EntityRotFX particle) {
        double centerX = particle.getPosX();
        double centerZ = particle.getPosZ();
        if (this.coordSource != null) {
            centerX = this.coordSource.xCoord;
            centerZ = this.coordSource.zCoord;
        }
        double vecX = centerX - particle.getPosX();
        double vecZ = centerZ - particle.getPosZ();
        double distToCenter = Math.sqrt(vecX * vecX + vecZ * vecZ);
        double rotYaw = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
        double adjYaw = Math.min(360, 45 + particle.getAge());
        rotYaw -= adjYaw;
        double speed = 0.1;
        if (particle.getAge() < 25 && distToCenter > 0.05) {
            particle.setMotionX(Math.cos(rotYaw * 0.017453) * speed);
            particle.setMotionZ(Math.sin(rotYaw * 0.017453) * speed);
        } else {
            double speed2 = 0.008;
            double pSpeed = Math.sqrt(particle.getMotionX() * particle.getMotionX() + particle.getMotionZ() * particle.getMotionZ());
            if (pSpeed < 0.2 && particle.getMotionY() < 0.01) {
                speed2 = 0.08;
            }
            if (pSpeed < 0.002 && Math.abs(particle.getMotionY()) < 0.02) {
                particle.setMotionY(particle.getMotionY() - 0.15);
            }
            particle.setMotionX(particle.getMotionX() + (this.rand.nextDouble() - this.rand.nextDouble()) * speed2);
            particle.setMotionZ(particle.getMotionZ() + (this.rand.nextDouble() - this.rand.nextDouble()) * speed2);
        }
        float brightnessShiftRate = this.rateDarken;
        int stateChangeTick = this.tickSmokifyTrigger;
        if (particle.getAge() < stateChangeTick) {
            particle.setGravity(-0.2f);
            particle.func_70538_b(particle.func_70534_d() - brightnessShiftRate, particle.func_70542_f() - brightnessShiftRate, particle.func_70535_g() - brightnessShiftRate);
        } else if (particle.getAge() == stateChangeTick) {
            particle.func_70538_b(0.0f, 0.0f, 0.0f);
        } else {
            brightnessShiftRate = this.rateBrighten;
            particle.setGravity(-0.05f);
            if (!(particle.func_70534_d() < 0.3f)) {
                brightnessShiftRate = this.rateBrightenSlower;
            }
            particle.func_70538_b(particle.func_70534_d() + brightnessShiftRate, particle.func_70542_f() + brightnessShiftRate, particle.func_70535_g() + brightnessShiftRate);
            if (particle.getAlphaF() > 0.0f) {
                particle.func_82338_g(particle.getAlphaF() - this.rateAlpha);
            } else {
                particle.func_187112_i();
            }
        }
        if (particle.getScale() < 8.0f) {
            particle.setScale(particle.getScale() + this.rateScale);
        }
    }

    public void tickUpdateCloud(EntityRotFX particle) {
        particle.rotationYaw = (float)((double)particle.rotationYaw - 0.1);
        int ticksFadeInMax = 100;
        if (particle.getAge() < ticksFadeInMax) {
            particle.func_82338_g((float)particle.getAge() * 0.01f);
        } else if (particle.getAlphaF() > 0.0f) {
            particle.func_82338_g(particle.getAlphaF() - this.rateAlpha * 1.3f);
        } else {
            particle.func_187112_i();
        }
    }

    public EntityRotFX spawnNewParticleIconFX(World world, TextureAtlasSprite icon, double x, double y, double z, double vecX, double vecY, double vecZ) {
        return this.spawnNewParticleIconFX(world, icon, x, y, z, vecX, vecY, vecZ, 0);
    }

    public EntityRotFX spawnNewParticleIconFX(World world, TextureAtlasSprite icon, double x, double y, double z, double vecX, double vecY, double vecZ, int renderOrder) {
        ParticleTexFX entityfx = new ParticleTexFX(world, x, y, z, vecX, vecY, vecZ, icon);
        entityfx.pb = this;
        entityfx.renderOrder = renderOrder;
        return entityfx;
    }

    public EntityRotFX initParticle(EntityRotFX particle) {
        particle.setPrevPosX(particle.getPosX());
        particle.setPrevPosY(particle.getPosY());
        particle.setPrevPosZ(particle.getPosZ());
        particle.func_187115_a(0.01f, 0.01f);
        return particle;
    }

    public static EntityRotFX setParticleRandoms(EntityRotFX particle, boolean yaw, boolean pitch) {
        Random rand = new Random();
        if (yaw) {
            particle.rotationYaw = rand.nextInt(360);
        }
        if (pitch) {
            particle.rotationPitch = rand.nextInt(360);
        }
        return particle;
    }

    public static EntityRotFX setParticleFire(EntityRotFX particle) {
        Random rand = new Random();
        particle.func_70538_b(0.6f + rand.nextFloat() * 0.4f, 0.2f + rand.nextFloat() * 0.2f, 0.0f);
        particle.setScale(0.25f + 0.2f * rand.nextFloat());
        particle.brightness = 1.0f;
        particle.func_187115_a(0.1f, 0.1f);
        particle.func_82338_g(0.6f);
        return particle;
    }

    public static EntityRotFX setParticleCloud(EntityRotFX particle, float freezeY) {
        particle.spawnY = freezeY;
        particle.rotationPitch = 90.0f;
        particle.setCanCollide(false);
        particle.func_187115_a(0.25f, 0.25f);
        particle.setScale(500.0f);
        particle.callUpdateSuper = false;
        particle.callUpdatePB = false;
        particle.func_187114_a(500);
        particle.func_70538_b(1.0f, 1.0f, 1.0f);
        particle.brightness = 0.3f;
        particle.renderRange = 999.0f;
        particle.func_82338_g(0.0f);
        return particle;
    }

    public void cleanup() {
    }
}

