/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.packet;

import CoroUtil.config.ConfigBlockDestruction;
import CoroUtil.forge.CoroUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHelper {
    @SideOnly(value=Side.CLIENT)
    public static void sendClientPacket(Packet packet) {
        FMLClientHandler.instance().getClient().field_71439_g.field_71174_a.func_147297_a(packet);
    }

    public static void writeTEntToPacket(TileEntity tEnt, NBTTagCompound nbt) {
        try {
            nbt.func_74768_a("dimID", tEnt.func_145831_w().field_73011_w.getDimension());
            nbt.func_74768_a("x", tEnt.func_174877_v().func_177958_n());
            nbt.func_74768_a("y", tEnt.func_174877_v().func_177956_o());
            nbt.func_74768_a("z", tEnt.func_174877_v().func_177952_p());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FMLProxyPacket createPacketForNBTHandler(String parChannel, String packetChannel, NBTTagCompound parNBT) {
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)parChannel);
            ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)parNBT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new FMLProxyPacket(new PacketBuffer(byteBuf), packetChannel);
    }

    public static FMLProxyPacket createPacketForTEntDWClient(TileEntity tEnt, String name, Object val) {
        CoroUtil.dbg("createPacketForTEntDWClient incomplete");
        ByteBuf byteBuf = Unpooled.buffer();
        return new FMLProxyPacket(new PacketBuffer(byteBuf), CoroUtil.eventChannelName);
    }

    public static FMLProxyPacket createPacketForTEntDWServer(TileEntity tEnt) {
        CoroUtil.dbg("createPacketForTEntDWServer incomplete");
        ByteBuf byteBuf = Unpooled.buffer();
        return new FMLProxyPacket(new PacketBuffer(byteBuf), CoroUtil.eventChannelName);
    }

    public static FMLProxyPacket createPacketForTEntCommand(TileEntity tEnt, NBTTagCompound data) {
        ByteBuf byteBuf = Unpooled.buffer();
        NBTTagCompound nbtSendData = new NBTTagCompound();
        try {
            nbtSendData.func_74778_a("command", "CoroAI_TEntCmd");
            nbtSendData.func_74768_a("dimID", tEnt.func_145831_w().field_73011_w.getDimension());
            nbtSendData.func_74768_a("x", tEnt.func_174877_v().func_177958_n());
            nbtSendData.func_74768_a("y", tEnt.func_174877_v().func_177956_o());
            nbtSendData.func_74768_a("z", tEnt.func_174877_v().func_177952_p());
            nbtSendData.func_74782_a("data", (NBTBase)data);
            ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)nbtSendData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new FMLProxyPacket(new PacketBuffer(byteBuf), CoroUtil.eventChannelName);
    }

    public static NBTTagCompound readNBTTagCompound(ByteBuf fullBuffer) throws IOException {
        return ByteBufUtils.readTag((ByteBuf)fullBuffer);
    }

    public static FMLProxyPacket getNBTPacket(NBTTagCompound parNBT, String parChannel) {
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)parNBT);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new FMLProxyPacket(new PacketBuffer(byteBuf), parChannel);
    }

    public static FMLProxyPacket getPacketForRelativeMotion(Entity ent, double motionX, double motionY, double motionZ) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("command", "Ent_Motion");
        data.func_74768_a("entityID", ent.func_145782_y());
        data.func_74780_a("motionX", motionX);
        data.func_74780_a("motionY", motionY);
        data.func_74780_a("motionZ", motionZ);
        return PacketHelper.getNBTPacket(data, CoroUtil.eventChannelName);
    }

    public static FMLProxyPacket getPacketForUpdateBlockList() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("command", "UpdateBlockList");
        data.func_74778_a("blacklistRepairable_RegularBlocks", ConfigBlockDestruction.blacklistRepairable_RegularBlocks);
        data.func_74778_a("whitelistMineable_TileEntities", ConfigBlockDestruction.whitelistMineable_TileEntities);
        return PacketHelper.getNBTPacket(data, CoroUtil.eventChannelName);
    }

    public static FMLProxyPacket getPacketForDebugRender(BlockPos pos, int time, int color, int type) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("command", "DebugRender");
        data.func_74780_a("posX", (double)pos.func_177958_n());
        data.func_74780_a("posY", (double)pos.func_177956_o());
        data.func_74780_a("posZ", (double)pos.func_177952_p());
        data.func_74768_a("color", color);
        data.func_74768_a("type", type);
        data.func_74768_a("time", time);
        return PacketHelper.getNBTPacket(data, CoroUtil.eventChannelName);
    }

    public static FMLProxyPacket getPacketForDebugRenderClear() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("command", "DebugRenderClear");
        return PacketHelper.getNBTPacket(data, CoroUtil.eventChannelName);
    }

    public static void spawnDebugRender(int dimID, BlockPos pos, int time, int color, int type) {
        CoroUtil.eventChannel.sendToDimension(PacketHelper.getPacketForDebugRender(pos, time, color, type), dimID);
    }

    public static void clearDebugRender(int dimID) {
        CoroUtil.eventChannel.sendToDimension(PacketHelper.getPacketForDebugRenderClear(), dimID);
    }

    public static void syncBlockLists() {
        if (PacketHelper.getServerPlayerCount() <= 0) {
            return;
        }
        CoroUtil.eventChannel.sendToAll(PacketHelper.getPacketForUpdateBlockList());
    }

    public static int getServerPlayerCount() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return 0;
        }
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al() == null) {
            return 0;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72394_k();
    }
}

