/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.ai.tasks;

import CoroUtil.ai.IInvasionControlledTask;
import CoroUtil.ai.ITaskInitializer;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilPath;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIChaseFromFar
extends EntityAIBase
implements ITaskInitializer,
IInvasionControlledTask {
    World world;
    protected EntityCreature attacker;
    protected int attackTick;
    double speedTowardsTarget = 1.0;
    boolean longMemory = false;
    Path entityPathEntity;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private int failedPathFindingPenalty = 0;
    private boolean disableAtSunrise = true;

    public EntityAIChaseFromFar() {
        this.func_75248_a(0);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (CoroUtilEntity.canPathfindLongDist(this.attacker)) {
            boolean debugTPSSpike = false;
            if (debugTPSSpike) {
                CULog.dbg("EntityAIChaseFromFar shouldExecute trypath: " + this.attacker.field_70170_p.func_82737_E());
            }
            CoroUtilPath.tryMoveToEntityLivingLongDist((EntityLiving)this.attacker, (Entity)entitylivingbase, 1.0);
            CoroUtilEntity.updateLastTimeLongDistPathfinded(this.attacker);
            this.entityPathEntity = this.attacker.func_70661_as().func_75505_d();
            if (this.entityPathEntity != null) {
                return true;
            }
            return this.getAttackReachSqr(entitylivingbase) >= this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        }
        return false;
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.func_70661_as().func_75500_f();
        }
        if (!this.attacker.func_180485_d(new BlockPos((Entity)entitylivingbase))) {
            return false;
        }
        return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).func_175149_v() && !((EntityPlayer)entitylivingbase).func_184812_l_();
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.entityPathEntity, this.speedTowardsTarget);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (!(entitylivingbase instanceof EntityPlayer) || ((EntityPlayer)entitylivingbase).func_175149_v() || ((EntityPlayer)entitylivingbase).func_184812_l_()) {
            // empty if block
        }
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            this.func_75251_c();
            return;
        }
        this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
        double d0 = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        --this.delayCounter;
        if ((this.longMemory || this.delayCounter <= 0 && this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = entitylivingbase.field_70165_t;
            this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
            this.targetZ = entitylivingbase.field_70161_v;
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (CoroUtilEntity.canPathfindLongDist(this.attacker)) {
                CoroUtilEntity.updateLastTimeLongDistPathfinded(this.attacker);
                if (!CoroUtilPath.tryMoveToEntityLivingLongDist((EntityLiving)this.attacker, (Entity)entitylivingbase, 1.0)) {
                    this.delayCounter += 15;
                }
            }
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }

    @Override
    public void setEntity(EntityCreature creature) {
        this.attacker = creature;
    }

    @Override
    public boolean shouldBeRemoved() {
        if (this.disableAtSunrise && ConfigCoroUtilAdvanced.removeInvasionAIWhenInvasionDone && this.attacker.field_70170_p.func_72935_r()) {
            CULog.dbg("removing long distance pathing from " + this.attacker.func_70005_c_());
            return true;
        }
        return false;
    }
}

