/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import party.lemons.arcaneworld.ArcaneWorld;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.crafting.ritual.RitualRegistry;
import party.lemons.arcaneworld.item.ArcaneWorldItems;
import party.lemons.arcaneworld.item.impl.ItemRitualScroll;

public class ArcaneWorldUtil {
    public static ItemStack getRandomRitualScrollForDrop(Random random) {
        List list = RitualRegistry.REGISTRY.getValuesCollection().stream().filter(Ritual::canDrop).collect(Collectors.toList());
        ItemStack stack = new ItemStack(ArcaneWorldItems.RITUAL_SCROLL);
        ItemRitualScroll.setRitual(stack, (Ritual)((Object)list.get(random.nextInt(list.size()))));
        return stack;
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        ArcaneWorldUtil.dropInventoryItems(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), inventory);
    }

    public static void dropInventoryItems(World worldIn, Entity entityAt, IItemHandler inventory) {
        ArcaneWorldUtil.dropInventoryItems(worldIn, entityAt.field_70165_t, entityAt.field_70163_u, entityAt.field_70161_v, inventory);
    }

    private static void dropInventoryItems(World worldIn, double x, double y, double z, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)x, (double)y, (double)z, (ItemStack)itemstack);
        }
    }

    public static boolean ingredientMatch(Ingredient ingredient, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ItemStack itemstack : ingredient.func_193365_a()) {
            int i;
            if (itemstack.func_77973_b() != stack.func_77973_b() || itemstack.func_190916_E() > stack.func_190916_E() || (i = itemstack.func_77960_j()) != Short.MAX_VALUE && i != stack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String inputPath, String outputPath) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int bytesRead;
            inputStream = ArcaneWorld.class.getResourceAsStream(inputPath);
            outputStream = new FileOutputStream(outputPath);
            byte[] buf = new byte[1024];
            while ((bytesRead = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, bytesRead);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }
}

