/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.network;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.arcaneworld.handler.ArcaneWorldSounds;

public class MessageUpdateBiomeArea
implements IMessage {
    public AxisAlignedBB bb;
    private byte biome;

    public MessageUpdateBiomeArea() {
    }

    public MessageUpdateBiomeArea(Biome biome, AxisAlignedBB bb) {
        this.bb = bb;
        this.biome = (byte)Biome.func_185362_a((Biome)biome);
    }

    public void fromBytes(ByteBuf buf) {
        int mixX = buf.readInt();
        int maxX = buf.readInt();
        int mixY = buf.readInt();
        int maxY = buf.readInt();
        int mixZ = buf.readInt();
        int maxZ = buf.readInt();
        this.biome = buf.readByte();
        this.bb = new AxisAlignedBB((double)mixX, (double)mixY, (double)mixZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt((int)this.bb.field_72340_a);
        buf.writeInt((int)this.bb.field_72336_d);
        buf.writeInt((int)this.bb.field_72338_b);
        buf.writeInt((int)this.bb.field_72337_e);
        buf.writeInt((int)this.bb.field_72339_c);
        buf.writeInt((int)this.bb.field_72334_f);
        buf.writeByte((int)this.biome);
    }

    public static class Handler
    implements IMessageHandler<MessageUpdateBiomeArea, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageUpdateBiomeArea message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                AxisAlignedBB bb = message.bb;
                int x = (int)bb.field_72340_a;
                while ((double)x < bb.field_72336_d) {
                    int z = (int)bb.field_72339_c;
                    while ((double)z < bb.field_72334_f) {
                        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_175726_f(new BlockPos((double)x, bb.field_72338_b, (double)z));
                        chunk.func_76605_m()[(z & 0xF) << 4 | x & 0xF] = message.biome;
                        chunk.func_177427_f(true);
                        if ((double)x == bb.field_72340_a || (double)x == bb.field_72336_d || (double)z == bb.field_72339_c || (double)z == bb.field_72334_f) {
                            for (int i = 0; i < 1; ++i) {
                                Random random = new Random();
                                Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)x + random.nextFloat()), bb.field_72338_b + 1.0, (double)((float)z + random.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                            }
                        }
                        ++z;
                    }
                    ++x;
                }
                BlockPos center = new BlockPos(bb.func_189972_c());
                Minecraft.func_71410_x().field_71441_e.func_184156_a(center, ArcaneWorldSounds.GENERAL_BREAK_SQUISH, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                Minecraft.func_71410_x().field_71438_f.func_147585_a((int)bb.field_72340_a, 0, (int)bb.field_72339_c, (int)bb.field_72336_d, Minecraft.func_71410_x().field_71441_e.func_72800_K(), (int)bb.field_72334_f);
            });
            return null;
        }
    }
}

