/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.item.impl;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.arcaneworld.item.ArcaneWorldItems;

public class ItemRecaller
extends Item {
    public ItemRecaller() {
        this.func_77656_e(75);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.recallIf(player, world, stack)) {
            ItemRecaller.setPosition(stack, world, pos.func_177972_a(facing));
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return new ActionResult(this.recallIf(player, world, stack) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, (Object)stack);
    }

    private boolean recallIf(EntityPlayer player, World world, ItemStack stack) {
        if (ItemRecaller.getPosition(stack) != null && ItemRecaller.getDimension(stack) != Integer.MAX_VALUE) {
            this.recall(player, world, stack);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemRecaller.getPosition(stack) != null && ItemRecaller.getDimension(stack) == worldIn.field_73011_w.getDimension()) {
            BlockPos pos = ItemRecaller.getPosition(stack);
            tooltip.add(TextFormatting.GOLD + "X: " + pos.func_177958_n());
            tooltip.add(TextFormatting.GOLD + "Y: " + pos.func_177956_o());
            tooltip.add(TextFormatting.GOLD + "Z: " + pos.func_177952_p());
        }
    }

    public void recall(EntityPlayer player, World world, ItemStack stack) {
        if (world.field_72995_K || ItemRecaller.getDimension(stack) != world.field_73011_w.getDimension()) {
            return;
        }
        BlockPos pos = ItemRecaller.getPosition(stack);
        ((WorldServer)world).func_175739_a(EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, 40, 0.0, 0.0, 0.0, 1.0, new int[0]);
        player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
        ((WorldServer)world).func_175739_a(EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, 40, 0.0, 0.0, 0.0, 5.0, new int[0]);
        stack.func_77972_a(1, (EntityLivingBase)player);
        ItemRecaller.setPosition(stack, world, null);
        player.func_184811_cZ().func_185145_a((Item)this, 25);
    }

    public static BlockPos getPosition(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74764_b("position")) {
            return NBTUtil.func_186861_c((NBTTagCompound)tags.func_74775_l("position"));
        }
        return null;
    }

    public static int getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Integer.MAX_VALUE;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74764_b("dim")) {
            return tags.func_74762_e("dim");
        }
        return Integer.MAX_VALUE;
    }

    public static void setPosition(ItemStack stack, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tags = !stack.func_77942_o() ? new NBTTagCompound() : stack.func_77978_p();
        if (pos == null) {
            tags.func_82580_o("position");
            tags.func_82580_o("dim");
        } else {
            tags.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            tags.func_74768_a("dim", world.field_73011_w.getDimension());
        }
        stack.func_77982_d(tags);
    }

    @Mod.EventBusSubscriber(modid="arcaneworld", value={Side.CLIENT})
    public static class RecallerModelRegister {
        @SubscribeEvent
        public static void onRegisterModel(ModelRegistryEvent event) {
            ModelResourceLocation recaller_off = new ModelResourceLocation(ArcaneWorldItems.RECALLER.getRegistryName() + "_off", "inventory");
            ModelResourceLocation recaller_on = new ModelResourceLocation(ArcaneWorldItems.RECALLER.getRegistryName() + "_on", "inventory");
            ModelBakery.registerItemVariants((Item)ArcaneWorldItems.RECALLER, (ResourceLocation[])new ResourceLocation[]{recaller_off, recaller_on});
            ModelLoader.setCustomMeshDefinition((Item)ArcaneWorldItems.RECALLER, s -> {
                if (s.func_77942_o() && s.func_77978_p().func_74764_b("position")) {
                    return recaller_on;
                }
                return recaller_off;
            });
        }
    }
}

