/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.item.impl;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.arcaneworld.crafting.ArcaneWorldSpamTab;
import party.lemons.arcaneworld.item.impl.ItemModel;

public class ItemPotionOrb
extends ItemModel {
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || !PotionUtils.func_185189_a((ItemStack)stack).isEmpty();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        List list = PotionUtils.func_185189_a((ItemStack)stack);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            String s = LanguageMap.func_74808_a().func_74805_b("effect.none").trim();
            tooltip.add(TextFormatting.GRAY + s);
        } else {
            for (PotionEffect potioneffect : list) {
                String s1 = LanguageMap.func_74808_a().func_74805_b(potioneffect.func_76453_d()).trim();
                Potion potion = potioneffect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (potioneffect.func_76458_c() > 0) {
                    s1 = s1 + " " + LanguageMap.func_74808_a().func_74805_b("potion.potency." + potioneffect.func_76458_c()).trim();
                }
                if (potion.func_76398_f()) {
                    tooltip.add(TextFormatting.RED + s1);
                    continue;
                }
                tooltip.add(TextFormatting.BLUE + s1);
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (PotionType effect : ForgeRegistries.POTION_TYPES) {
                if (effect.func_185170_a().isEmpty()) continue;
                ItemStack stack = new ItemStack((Item)this);
                PotionUtils.func_185188_a((ItemStack)stack, (PotionType)effect);
                items.add((Object)stack);
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean isOffhand;
        boolean isPlayer = entityIn instanceof EntityPlayer;
        boolean bl = isPlayer ? ((EntityPlayer)entityIn).func_184592_cb() == stack : (isOffhand = itemSlot == 0);
        if ((isOffhand || isSelected) && entityIn instanceof EntityLivingBase) {
            this.applyPotionEffects(stack, (EntityLivingBase)entityIn);
        }
    }

    public List<PotionEffect> getPotionEffects(ItemStack stack) {
        return PotionUtils.func_185189_a((ItemStack)stack);
    }

    public void applyPotionEffects(ItemStack stack, EntityLivingBase entity) {
        for (PotionEffect effect : this.getPotionEffects(stack)) {
            PotionEffect addedEffect = new PotionEffect(effect.func_188419_a(), 3, effect.func_76458_c(), true, false);
            entity.func_70690_d(addedEffect);
        }
    }

    @Nullable
    public CreativeTabs func_77640_w() {
        return ArcaneWorldSpamTab.INSTANCE;
    }

    public static class SetPotionLoot
    extends LootFunction {
        Potion[] effects = new Potion[]{MobEffects.field_188423_x, MobEffects.field_76436_u, MobEffects.field_82731_v, MobEffects.field_76421_d, MobEffects.field_76424_c, MobEffects.field_76440_q, MobEffects.field_76422_e, MobEffects.field_76426_n, MobEffects.field_76430_j, MobEffects.field_188425_z, MobEffects.field_76419_f, MobEffects.field_76431_k, MobEffects.field_76437_t, MobEffects.field_76427_o, MobEffects.field_189112_A, MobEffects.field_76420_g, MobEffects.field_76429_m, MobEffects.field_76428_l, MobEffects.field_76439_r};

        protected SetPotionLoot(LootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            PotionType[] effect_list = ForgeRegistries.POTION_TYPES.getValuesCollection().toArray(new PotionType[0]);
            int size = effect_list.length;
            PotionType effect = effect_list[rand.nextInt(size)];
            while (!this.isValidEffect(effect)) {
                effect = effect_list[rand.nextInt(size)];
            }
            PotionUtils.func_185188_a((ItemStack)stack, (PotionType)effect);
            return stack;
        }

        public boolean isValidEffect(PotionType effect) {
            for (int i = 0; i < this.effects.length; ++i) {
                if (((PotionEffect)effect.func_185170_a().get(0)).func_188419_a() != this.effects[i]) continue;
                return true;
            }
            return false;
        }

        public static class Serializer
        extends LootFunction.Serializer<SetPotionLoot> {
            public Serializer() {
                super(new ResourceLocation("arcaneworld", "random_potion"), SetPotionLoot.class);
            }

            public void serialize(@Nonnull JsonObject object, @Nonnull SetPotionLoot functionClazz, @Nonnull JsonSerializationContext serializationContext) {
            }

            @Nonnull
            public SetPotionLoot deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext deserializationContext, @Nonnull LootCondition[] conditionsIn) {
                return new SetPotionLoot(conditionsIn);
            }
        }
    }
}

