/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.handler.ticker;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import party.lemons.arcaneworld.ArcaneWorld;
import party.lemons.arcaneworld.network.MessageEventArcaneHoeChange;
import party.lemons.lemonlib.ticker.ITicker;

public class TickerHoe
implements ITicker {
    private World world;
    private int dimension;
    private int size;
    private int current;
    private int age;
    private EnumFacing direction;
    private BlockPos origin;
    private EntityPlayer player;
    private boolean stopped = false;
    private static Block[] hoeables = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150458_ak};

    public TickerHoe(World world) {
        this.world = world;
        this.age = 0;
        this.dimension = world.field_73011_w.getDimension();
    }

    public TickerHoe(World world, EntityPlayer player, int size, EnumFacing direction, BlockPos origin) {
        this(world);
        this.size = size;
        this.direction = direction;
        this.origin = origin;
        this.current = 0;
        this.dimension = world.field_73011_w.getDimension();
        this.player = player;
    }

    public void update(World world) {
        if (world.field_73011_w.getDimension() != this.dimension) {
            return;
        }
        BlockPos currentPos = this.getCurrentPos();
        IBlockState state = world.func_180495_p(currentPos);
        if (this.age % 3 == 0) {
            boolean set = false;
            if ((world.func_180495_p(currentPos.func_177984_a()).func_177230_c() instanceof IGrowable || world.func_175623_d(currentPos.func_177984_a())) && this.isHoeable(state)) {
                ItemStack offhand;
                world.func_175656_a(currentPos, Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)));
                if (this.player != null && world.func_175623_d(currentPos.func_177984_a()) && !(offhand = this.player.func_184592_cb()).func_190926_b() && offhand.func_77973_b() instanceof IPlantable) {
                    IBlockState plantState = ((IPlantable)offhand.func_77973_b()).getPlant((IBlockAccess)world, currentPos.func_177984_a());
                    if (state.func_177230_c().func_176196_c(world, currentPos.func_177984_a())) {
                        offhand.func_190918_g(1);
                        world.func_175656_a(currentPos.func_177984_a(), plantState);
                        state.func_177230_c().func_180633_a(world, currentPos.func_177984_a(), plantState, (EntityLivingBase)this.player, offhand);
                    }
                }
                ArcaneWorld.NETWORK.sendToAllTracking((IMessage)new MessageEventArcaneHoeChange(currentPos, this.current), new NetworkRegistry.TargetPoint(this.dimension, (double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p(), 64.0));
                set = true;
            }
            ++this.current;
            if (!set) {
                this.stopped = true;
            }
        }
        ++this.age;
    }

    private boolean isHoeable(IBlockState state) {
        for (int i = 0; i < hoeables.length; ++i) {
            if (hoeables[i] != state.func_177230_c()) continue;
            return true;
        }
        return false;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("size", this.size);
        tags.func_74768_a("dim", this.dimension);
        tags.func_74768_a("direction", this.direction.ordinal());
        tags.func_74768_a("current", this.current);
        tags.func_74782_a("origin", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.origin));
        return tags;
    }

    public void readFromNBT(NBTTagCompound tags) {
        this.size = tags.func_74762_e("size");
        this.direction = EnumFacing.values()[tags.func_74762_e("direction")];
        this.current = tags.func_74762_e("current");
        this.origin = NBTUtil.func_186861_c((NBTTagCompound)tags.func_74775_l("origin"));
        this.dimension = tags.func_74762_e("dim");
        this.world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dimension);
    }

    public boolean isTaskFinished(World world) {
        return this.current > this.size || this.stopped;
    }

    public int getDimension() {
        return this.world.field_73011_w.getDimension();
    }

    public boolean isUnique() {
        return false;
    }

    private BlockPos getCurrentPos() {
        return this.origin.func_177967_a(this.direction, this.current);
    }
}

