/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.gen.dungeon.generation;

import java.util.HashMap;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import party.lemons.arcaneworld.gen.dungeon.generation.Direction;

public class RoomDirection {
    private final HashMap<Direction, Boolean> directions = new HashMap();

    public RoomDirection() {
        this(false, false, false, false);
    }

    public RoomDirection(boolean up, boolean down, boolean left, boolean right) {
        this.directions.put(Direction.NORTH, up);
        this.directions.put(Direction.SOUTH, down);
        this.directions.put(Direction.EAST, left);
        this.directions.put(Direction.WEST, right);
    }

    public RoomDirection withDirection(Direction direction, boolean open) {
        this.directions.put(direction, open);
        return this;
    }

    public boolean isOpen(Direction direction) {
        return this.directions.get((Object)direction);
    }

    public boolean isSealed() {
        return this.equals(new RoomDirection());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RoomDirection)) {
            return super.equals(obj);
        }
        RoomDirection other = (RoomDirection)obj;
        for (Direction direction : Direction.values()) {
            if (other.isOpen(direction) == this.isOpen(direction)) continue;
            return false;
        }
        return true;
    }

    public String getDirectory() {
        return this.getShape().getDirectory();
    }

    public RoomShape getShape() {
        int openCount = this.getOpenCount();
        if (openCount == 0) {
            return RoomShape.SEALED;
        }
        if (openCount == 3) {
            return RoomShape.T;
        }
        if (openCount == 4) {
            return RoomShape.OPEN;
        }
        if (openCount == 1) {
            return RoomShape.CAP;
        }
        if (openCount == 2) {
            if (this.isOpen(Direction.SOUTH) && this.isOpen(Direction.NORTH) || this.isOpen(Direction.EAST) && this.isOpen(Direction.WEST)) {
                return RoomShape.CORRIDOR;
            }
            return RoomShape.CORNER;
        }
        return RoomShape.SEALED;
    }

    private int getOpenCount() {
        int count = 0;
        for (Direction direction : Direction.values()) {
            if (!this.isOpen(direction)) continue;
            ++count;
        }
        return count;
    }

    public Mirror getMirror() {
        return Mirror.NONE;
    }

    public Rotation getRotation() {
        Rotation rotation = Rotation.NONE;
        RoomShape shape = this.getShape();
        switch (shape) {
            case CORNER: {
                if (this.isOpen(Direction.NORTH) && this.isOpen(Direction.EAST)) {
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                if (this.isOpen(Direction.SOUTH) && this.isOpen(Direction.EAST)) {
                    rotation = Rotation.CLOCKWISE_180;
                    break;
                }
                if (!this.isOpen(Direction.SOUTH) || !this.isOpen(Direction.WEST)) break;
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case T: {
                if (this.isOpen(Direction.NORTH) && this.isOpen(Direction.SOUTH) && this.isOpen(Direction.EAST)) {
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                if (this.isOpen(Direction.SOUTH) && this.isOpen(Direction.EAST) && this.isOpen(Direction.WEST)) {
                    rotation = Rotation.CLOCKWISE_180;
                    break;
                }
                if (!this.isOpen(Direction.NORTH) || !this.isOpen(Direction.SOUTH) || !this.isOpen(Direction.WEST)) break;
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case CORRIDOR: {
                if (!this.isOpen(Direction.EAST)) break;
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case CAP: {
                if (this.isOpen(Direction.NORTH)) {
                    rotation = Rotation.NONE;
                }
                if (this.isOpen(Direction.EAST)) {
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                if (this.isOpen(Direction.WEST)) {
                    rotation = Rotation.COUNTERCLOCKWISE_90;
                    break;
                }
                if (!this.isOpen(Direction.SOUTH)) break;
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
        }
        return rotation;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Direction direction : Direction.values()) {
            s.append(direction.toString()).append(" ").append(this.isOpen(direction)).append(", ");
        }
        return s.toString();
    }

    static enum RoomShape {
        SEALED("sealed"),
        OPEN("open"),
        CORNER("corner"),
        T("t"),
        CORRIDOR("corridor"),
        CAP("cap");

        private String directory;

        private RoomShape(String directory) {
            this.directory = directory;
        }

        public String getDirectory() {
            return this.directory;
        }
    }
}

