/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.gen.dungeon.generation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import party.lemons.arcaneworld.gen.dungeon.generation.Direction;
import party.lemons.arcaneworld.gen.dungeon.generation.DungeonRoomProcessor;
import party.lemons.arcaneworld.gen.dungeon.generation.RoomDirection;
import party.lemons.arcaneworld.gen.dungeon.generation.TickerDungeon;
import party.lemons.lemonlib.ticker.ITicker;
import party.lemons.lemonlib.ticker.TickerHandler;

public class DungeonGenerator {
    private static Map<String, List<ResourceLocation>> cachedTemplates = new HashMap<String, List<ResourceLocation>>();
    private static final int MIN_WIDTH = 5;
    private static final int MIN_HEIGHT = 5;
    private static final int MAX_WIDTH = 10;
    private static final int MAX_HEIGHT = 10;
    public static final int ROOM_WIDTH = 13;
    private BlockPos origin;
    private World world;
    private Random random;
    private int width;
    private int height;
    private RoomDirection[][] directions;

    public DungeonGenerator(World world, BlockPos origin) {
        this.world = world;
        this.origin = origin;
        this.random = world.field_73012_v;
        this.width = 5 + this.random.nextInt(6);
        this.height = 5 + this.random.nextInt(6);
        this.directions = new RoomDirection[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.directions[i][j] = new RoomDirection();
            }
        }
    }

    public void generate() {
        this.createLayout();
        TickerHandler.addTicker((ITicker)new TickerDungeon(this.world, this), (int)this.world.field_73011_w.getDimension());
    }

    public boolean generateRoom(int x, int y) {
        RoomDirection direction = this.directions[x][y];
        if (!direction.isSealed()) {
            ResourceLocation layout;
            BlockPos generatePos = this.origin.func_177982_a(x * 13, 0, y * 13);
            Rotation rotation = direction.getRotation();
            int offsetX = 0;
            int offsetZ = 0;
            switch (rotation) {
                case CLOCKWISE_90: {
                    offsetX = 12;
                    break;
                }
                case CLOCKWISE_180: {
                    offsetX = 12;
                    offsetZ = 12;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    offsetZ = 12;
                    break;
                }
            }
            PlacementSettings settings = new PlacementSettings().func_186220_a(direction.getRotation()).func_186214_a(direction.getMirror());
            if (x == 0 && y == 0) {
                switch (direction.getShape()) {
                    case OPEN: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/start/open_start_1");
                        break;
                    }
                    case CORNER: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/start/corner_start_1");
                        break;
                    }
                    case T: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/start/t_start_1");
                        break;
                    }
                    case CORRIDOR: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/start/corridor_start_1");
                        break;
                    }
                    case CAP: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/start/cap_start_1");
                        break;
                    }
                    default: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/start/end_start_1");
                        break;
                    }
                }
            } else if (x == this.width - 1 && y == this.height - 1) {
                switch (direction.getShape()) {
                    case OPEN: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/portals/open_end_1");
                        break;
                    }
                    case CORNER: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/portals/corner_end_1");
                        break;
                    }
                    case T: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/portals/t_end_1");
                        break;
                    }
                    case CORRIDOR: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/portals/corridor_end_1");
                        break;
                    }
                    case CAP: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/portals/end_cap_1");
                        break;
                    }
                    default: {
                        layout = new ResourceLocation("arcaneworld", "dungeon/portals/end_cap_1");
                        break;
                    }
                }
            } else {
                layout = this.getRoomLayout(direction);
            }
            Template template = this.world.func_72860_G().func_186340_h().func_186237_a(this.world.func_73046_m(), layout);
            template.func_189960_a(this.world, generatePos.func_177982_a(offsetX, 0, offsetZ), (ITemplateProcessor)new DungeonRoomProcessor(), settings, 2);
            return true;
        }
        return false;
    }

    private void createLayout() {
        int x = 0;
        int z = 0;
        boolean finished = false;
        while (!finished) {
            RoomDirection currentRoom = this.directions[x][z];
            if (z != this.height - 1) {
                Direction moveDirection;
                Direction direction = moveDirection = this.random.nextBoolean() ? Direction.EAST : Direction.WEST;
                if (x + moveDirection.getX() <= 0 || x + moveDirection.getX() >= this.width) {
                    moveDirection = Direction.SOUTH;
                }
                currentRoom.withDirection(moveDirection, true);
                this.directions[x + moveDirection.getX()][z + moveDirection.getY()].withDirection(moveDirection.opposite(), true);
                x += moveDirection.getX();
                z += moveDirection.getY();
                continue;
            }
            if (x != this.width - 1) {
                currentRoom.withDirection(Direction.EAST, true);
                this.directions[x + 1][z].withDirection(Direction.WEST, true);
                ++x;
                continue;
            }
            finished = true;
        }
        for (int i = 0; i < 40; ++i) {
            int mutateX = this.random.nextInt(this.width);
            int mutateZ = this.random.nextInt(this.height);
            RoomDirection direction = this.directions[mutateX][mutateZ];
            Direction mutateDir = Direction.random();
            if (direction.isSealed() || mutateX == 0 && mutateDir.getX() < 0 || mutateX == this.width - 1 && mutateDir.getX() > 0 || mutateZ == 0 && mutateDir.getY() < 0 || mutateZ == this.height - 1 && mutateDir.getY() > 0) continue;
            Direction moveDirection = mutateDir;
            direction.withDirection(moveDirection, true);
            this.directions[mutateX + mutateDir.getX()][mutateZ + mutateDir.getY()].withDirection(moveDirection.opposite(), true);
        }
    }

    public ResourceLocation getRoomLayout(RoomDirection direction) {
        String directory = direction.getDirectory();
        if (!cachedTemplates.containsKey(directory)) {
            ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
            switch (directory) {
                case "cap": {
                    this.loadTemplates(locations, directory, 15);
                    break;
                }
                case "corner": {
                    this.loadTemplates(locations, directory, 5);
                    break;
                }
                case "corridor": {
                    this.loadTemplates(locations, directory, 10);
                    break;
                }
                case "open": {
                    this.loadTemplates(locations, directory, 1);
                    break;
                }
                case "sealed": {
                    locations.add(new ResourceLocation("arcaneworld", "dungeon/" + directory + "/" + directory));
                    break;
                }
                case "t": {
                    this.loadTemplates(locations, directory, 11);
                }
            }
            cachedTemplates.put(directory, locations);
        }
        List<ResourceLocation> selectFrom = cachedTemplates.get(directory);
        return selectFrom.get(this.random.nextInt(selectFrom.size()));
    }

    private void loadTemplates(List<ResourceLocation> locations, String directory, int size) {
        for (int i = 1; i < size + 1; ++i) {
            locations.add(new ResourceLocation("arcaneworld", "dungeon/" + directory + "/" + directory + "_" + i));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

