/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.gen.dungeon.dimension;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import party.lemons.arcaneworld.block.ArcaneWorldBlocks;
import party.lemons.arcaneworld.config.ArcaneWorldConfig;
import party.lemons.arcaneworld.gen.dungeon.dimension.DungeonDimensionProvider;

public class DungeonDimension {
    public static DimensionType TYPE = DimensionType.register((String)"dungeon", (String)"dungeon", (int)ArcaneWorldConfig.DUNGEONS.DIM_ID, DungeonDimensionProvider.class, (boolean)false);

    public static void init() {
        DimensionManager.registerDimension((int)ArcaneWorldConfig.DUNGEONS.DIM_ID, (DimensionType)TYPE);
    }

    private static void cancelIfInDim(World world, Event event) {
        if (DungeonDimension.isInDim(world)) {
            event.setCanceled(true);
        }
    }

    private static void denyIfInDim(World world, Event event) {
        if (DungeonDimension.isInDim(world)) {
            event.setResult(Event.Result.DENY);
        }
    }

    private static boolean isInDim(World world) {
        return world.field_73011_w.getDimension() == ArcaneWorldConfig.DUNGEONS.DIM_ID;
    }

    @Mod.EventBusSubscriber(modid="arcaneworld", value={Side.CLIENT})
    public static class DungeonDimensionEventsClient {
        @SubscribeEvent
        public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
            BlockPos pos;
            World world;
            IBlockState state;
            if (!DungeonDimension.isInDim(event.getPlayer().field_70170_p)) {
                return;
            }
            event.setCanceled(true);
            if (event.getTarget().func_178782_a() != null && ((state = (world = event.getPlayer().field_70170_p).func_180495_p(pos = event.getTarget().func_178782_a())).func_177230_c().hasTileEntity(state) || world.func_175625_s(pos) instanceof IInventory)) {
                event.setCanceled(false);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="arcaneworld")
    public static class DungeonDimensionEvents {
        @SubscribeEvent
        public static void onEntityDeath(LivingDeathEvent event) {
            World world = event.getEntity().field_70170_p;
            if (DungeonDimension.isInDim(world) && event.getEntity().func_184216_O().contains("arena_entity")) {
                int z;
                int x;
                BlockPos pos = event.getEntity().func_180425_c();
                while (world.func_175623_d(pos)) {
                    pos = pos.func_177977_b();
                }
                BlockPos startPos = pos.func_177981_b(3);
                for (x = -1; x < 4; ++x) {
                    for (z = -1; z < 3; ++z) {
                        world.func_175656_a(startPos.func_177979_c(x).func_177985_f(z), Blocks.field_150343_Z.func_176223_P());
                    }
                }
                for (x = 0; x < 3; ++x) {
                    for (z = 0; z < 2; ++z) {
                        world.func_175656_a(startPos.func_177979_c(x).func_177985_f(z), ArcaneWorldBlocks.RETURN_PORTAL.func_176223_P());
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onPlaceBlock(BlockEvent.PlaceEvent event) {
            DungeonDimension.cancelIfInDim(event.getWorld(), (Event)event);
        }

        @SubscribeEvent
        public static void onBreakBlock(BlockEvent.BreakEvent event) {
            DungeonDimension.cancelIfInDim(event.getWorld(), (Event)event);
        }

        @SubscribeEvent
        public static void onExplode(ExplosionEvent.Detonate event) {
            if (DungeonDimension.isInDim(event.getWorld())) {
                event.getAffectedBlocks().clear();
            }
        }

        @SubscribeEvent
        public static void onMobGriefing(EntityMobGriefingEvent event) {
            if (event.getEntity() != null) {
                DungeonDimension.denyIfInDim(event.getEntity().field_70170_p, (Event)event);
            }
        }

        @SubscribeEvent
        public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
            DungeonDimension.cancelIfInDim(event.getEntityPlayer().field_70170_p, (Event)event);
        }

        @SubscribeEvent
        public static void onUseItem(PlayerInteractEvent.RightClickItem event) {
            ItemStack stack;
            if (DungeonDimension.isInDim(event.getWorld()) && (stack = event.getItemStack()).func_77973_b() instanceof ItemBlock) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            DungeonDimension.cancelIfInDim(event.getWorld(), (Event)event);
        }
    }
}

