/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.gen;

import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import party.lemons.arcaneworld.block.ArcaneWorldBlocks;
import party.lemons.arcaneworld.config.ArcaneWorldConfig;
import party.lemons.arcaneworld.gen.BiomeArcaneDungeon;
import party.lemons.arcaneworld.gen.BiomeArcaneVoid;
import party.lemons.arcaneworld.gen.FeatureRift;
import party.lemons.lemonlib.gen.feature.FeatureChance;
import party.lemons.lemonlib.gen.feature.FeatureDimension;
import party.lemons.lemonlib.gen.feature.FeatureRange;
import party.lemons.lemonlib.gen.feature.FeatureVein;

@Mod.EventBusSubscriber(modid="arcaneworld")
@GameRegistry.ObjectHolder(value="arcaneworld")
public class ArcaneWorldGen {
    public static final Biome ARCANE_VOID = Biomes.field_185440_P;
    private static final WorldGenerator AMETHYST_GENERATOR = ArcaneWorldGen.getOreGenerator(() -> ((Block)ArcaneWorldBlocks.ORE_AMETHYST).func_176223_P(), b -> b.func_177230_c() == Blocks.field_150377_bs, ArcaneWorldConfig.ORES.AMETHYST_GENERATION.vein_size, ArcaneWorldConfig.ORES.AMETHYST_GENERATION.vein_count, ArcaneWorldConfig.ORES.AMETHYST_GENERATION.min_height, ArcaneWorldConfig.ORES.AMETHYST_GENERATION.max_height, 1);
    private static final WorldGenerator AMETHYST_GENERATOR_NETHER = ArcaneWorldGen.getOreGenerator(() -> ((Block)ArcaneWorldBlocks.ORE_AMETHYST_NETHER).func_176223_P(), b -> b.func_177230_c() == Blocks.field_150424_aL, ArcaneWorldConfig.ORES.AMETHYST_GENERATION_NETHER.vein_size, ArcaneWorldConfig.ORES.AMETHYST_GENERATION_NETHER.vein_count, ArcaneWorldConfig.ORES.AMETHYST_GENERATION_NETHER.min_height, ArcaneWorldConfig.ORES.AMETHYST_GENERATION_NETHER.max_height, -1);
    private static final WorldGenerator SAPPHIRE_GENERATOR = ArcaneWorldGen.getOreGenerator(() -> ((Block)ArcaneWorldBlocks.ORE_SAPPHIRE).func_176223_P(), b -> b.func_177230_c() == Blocks.field_150348_b, ArcaneWorldConfig.ORES.SAPPHIRE_GENERATION.vein_size, ArcaneWorldConfig.ORES.SAPPHIRE_GENERATION.vein_count, ArcaneWorldConfig.ORES.SAPPHIRE_GENERATION.min_height, ArcaneWorldConfig.ORES.SAPPHIRE_GENERATION.max_height, 0);
    private static final WorldGenerator SAPPHIRE_GENERATOR_WET = ArcaneWorldGen.getOreGenerator(() -> ((Block)ArcaneWorldBlocks.ORE_SAPPHIRE).func_176223_P(), b -> b.func_177230_c() == Blocks.field_150348_b, ArcaneWorldConfig.ORES.SAPPHIRE_GENERATION.vein_size, ArcaneWorldConfig.ORES.SAPPHIRE_GENERATION.vein_count * 3, ArcaneWorldConfig.ORES.SAPPHIRE_GENERATION.min_height, ArcaneWorldConfig.ORES.SAPPHIRE_GENERATION.max_height, 0);
    private static final WorldGenerator RIFT_GENERATOR = ArcaneWorldGen.getRiftGenerator();

    @SubscribeEvent
    public static void onRegisterBiome(RegistryEvent.Register<Biome> event) {
        Biome dungeonBiome = (Biome)new BiomeArcaneDungeon(new Biome.BiomeProperties("Arcane Dungeon").func_185396_a().func_185402_a(3684666)).setRegistryName("arcaneworld", "arcane_dungeon");
        event.getRegistry().register(new BiomeArcaneVoid(new Biome.BiomeProperties("arcane_void").func_185396_a().func_185402_a(3684666)).setRegistryName("arcaneworld", "arcane_void"));
        event.getRegistry().register((IForgeRegistryEntry)dungeonBiome);
        BiomeDictionary.addTypes((Biome)ARCANE_VOID, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.VOID});
        BiomeDictionary.addTypes((Biome)dungeonBiome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.VOID});
    }

    @SubscribeEvent
    public static void onPopulateChunk(PopulateChunkEvent.Pre event) {
        World world = event.getWorld();
        Random rand = event.getRand();
        BlockPos pos = new ChunkPos(event.getChunkX(), event.getChunkZ()).func_180331_a(8, 0, 8);
        Biome biome = world.func_180494_b(pos);
        (ArcaneWorldGen.isWetBiome(biome) ? SAPPHIRE_GENERATOR_WET : SAPPHIRE_GENERATOR).func_180709_b(world, rand, pos);
        AMETHYST_GENERATOR.func_180709_b(world, rand, pos);
        AMETHYST_GENERATOR_NETHER.func_180709_b(world, rand, pos);
        if (RIFT_GENERATOR != null) {
            RIFT_GENERATOR.func_180709_b(world, rand, pos);
        }
    }

    private static WorldGenerator getOreGenerator(Supplier<IBlockState> state, Predicate<IBlockState> predicate, int size, int count, int minHeight, int maxHeight, int ... dims) {
        return new FeatureDimension((WorldGenerator)new FeatureRange((WorldGenerator)new FeatureVein(b -> (IBlockState)state.get(), size, predicate), count, minHeight, maxHeight), dims);
    }

    private static WorldGenerator getRiftGenerator() {
        if (ArcaneWorldConfig.RIFTS.SPAWN_CHANCE <= 0) {
            return null;
        }
        return new FeatureChance((WorldGenerator)new FeatureRift(), ArcaneWorldConfig.RIFTS.SPAWN_CHANCE);
    }

    private static boolean isWetBiome(Biome biome) {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN).contains(biome) || BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.RIVER).contains(biome) || BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP).contains(biome);
    }
}

