/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.entity;

import java.util.List;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import party.lemons.arcaneworld.handler.ArcaneWorldSounds;
import party.lemons.arcaneworld.item.ArcaneWorldItems;

public class EntityRift
extends Entity {
    private int moveX;
    private int moveZ;
    private boolean hasCreatedExit;

    public EntityRift(World worldIn) {
        super(worldIn);
        this.func_189654_d(true);
        this.field_70178_ae = true;
        this.func_70105_a(3.0f, 3.0f);
    }

    public EntityRift(World world, int moveX, int moveZ) {
        this(world);
        this.moveX = moveX;
        this.moveZ = moveZ;
        this.hasCreatedExit = true;
    }

    protected void func_70088_a() {
        int bound = 5000000;
        this.moveX = -bound + this.field_70146_Z.nextInt(bound * 2);
        this.moveZ = -bound + this.field_70146_Z.nextInt(bound * 2);
        if (this.field_70165_t + (double)this.moveX > this.field_70170_p.func_175723_af().func_177728_d() || this.field_70165_t + (double)this.moveX < this.field_70170_p.func_175723_af().func_177726_b()) {
            this.moveX = 0;
        }
        if (this.field_70161_v + (double)this.moveZ > this.field_70170_p.func_175723_af().func_177733_e() || this.field_70161_v + (double)this.moveZ < this.field_70170_p.func_175723_af().func_177736_c()) {
            this.moveZ = 0;
        }
        this.hasCreatedExit = false;
    }

    public void func_174812_G() {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70146_Z.nextDouble() - 0.5, -this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble() - 0.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (this.field_70170_p.field_72995_K || this.field_70173_aa < 100) {
            return;
        }
        if (this.field_70146_Z.nextInt(100) == 0) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), ArcaneWorldSounds.RIFT_AMBIENT, SoundCategory.NEUTRAL, 0.1f, this.field_70146_Z.nextFloat() / 2.0f);
        }
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity.field_70128_L) continue;
            this.teleportEntity(entity);
        }
    }

    public void teleportEntity(Entity e) {
        if (this.field_70170_p.field_72995_K || e.func_184218_aH() || e.func_184207_aI()) {
            return;
        }
        this.field_70170_p.func_184133_a(null, e.func_180425_c(), ArcaneWorldSounds.RIFT_START, SoundCategory.NEUTRAL, 0.1f, 1.0f);
        if (e instanceof EntityPlayer) {
            if (((EntityPlayer)e).func_184811_cZ().func_185143_a(ArcaneWorldItems.RECALL_EYE, 0.0f) != 0.0f) {
                return;
            }
            ((EntityPlayer)e).func_184811_cZ().func_185145_a(ArcaneWorldItems.RECALL_EYE, 70);
        }
        if (!this.hasCreatedExit) {
            this.createExit();
        }
        BlockPos exitPos = this.getExitPosition();
        e.func_70634_a((double)exitPos.func_177958_n(), (double)exitPos.func_177956_o(), (double)exitPos.func_177952_p());
    }

    public BlockPos getExitPosition() {
        return this.func_180425_c().func_177982_a(this.moveX, 0, this.moveZ);
    }

    private void createExit() {
        BlockPos exitPos = this.getExitPosition();
        int radius = 5;
        for (int x = exitPos.func_177958_n() - radius; x < exitPos.func_177958_n() + radius; ++x) {
            for (int y = exitPos.func_177956_o() - radius; y < exitPos.func_177956_o() + radius; ++y) {
                for (int z = exitPos.func_177952_p() - radius; z < exitPos.func_177952_p() + radius; ++z) {
                    BlockPos p;
                    float squareDistance = (x - exitPos.func_177958_n()) * (x - exitPos.func_177958_n()) + (y - exitPos.func_177956_o()) * (y - exitPos.func_177956_o()) + (z - exitPos.func_177952_p()) * (z - exitPos.func_177952_p());
                    if (!((double)squareDistance <= Math.pow(radius, 2.0)) || !(this.field_70170_p.func_180495_p(p = new BlockPos(x, y, z)).func_185887_b(this.field_70170_p, p) > 0.0f)) continue;
                    this.field_70170_p.func_175698_g(p);
                }
            }
        }
        EntityRift rift = new EntityRift(this.field_70170_p, this.moveX * -1, this.moveZ * -1);
        rift.func_70634_a(exitPos.func_177958_n(), exitPos.func_177956_o(), exitPos.func_177952_p());
        this.field_70170_p.func_72838_d((Entity)rift);
        this.hasCreatedExit = true;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74762_e("x") != 0 || compound.func_74762_e("z") != 0) {
            this.moveX = compound.func_74762_e("x");
            this.moveZ = compound.func_74762_e("z");
            this.hasCreatedExit = compound.func_74767_n("exit");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("x", this.moveX);
        compound.func_74768_a("z", this.moveZ);
        compound.func_74757_a("exit", this.hasCreatedExit);
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 256.0) * d0;
    }

    public boolean func_70075_an() {
        return false;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }
}

