/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.crafting.ritual;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.crafting.ritual.RitualScroll;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualArena;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualCreateItem;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualDragonBreath;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualDungeon;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualSummon;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualTime;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualWeather;
import party.lemons.arcaneworld.item.ArcaneWorldItems;

@Mod.EventBusSubscriber(modid="arcaneworld")
public class Rituals {
    @SubscribeEvent
    public static void onRegisterRitual(RegistryEvent.Register<Ritual> event) {
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualScroll(Rituals.of(ArcaneWorldItems.RITUAL_SCROLL)), "ritual_scroll");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new Ritual(new Ingredient[0]){

            @Override
            public void onActivate(@Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player, ItemStack ... items) {
            }
        }.setEmpty(), "empty");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualTime(6000, Rituals.of(new ItemStack((Block)Blocks.field_150398_cm, 1, 0)), Rituals.of("dustGlowstone"), Rituals.of("nuggetGold"), Rituals.of("nuggetGold")), "time_skip");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualTime(-6000, Rituals.of("gemQuartz"), Rituals.of("dustRedstone"), Rituals.of("nuggetGold"), Rituals.of("nuggetGold")), "time_rewind");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualWeather(RitualWeather.WeatherType.CLEAR, Rituals.of("sand"), Rituals.of(Items.field_151065_br)), "clear_skies");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualWeather(RitualWeather.WeatherType.RAIN, Rituals.of("dustPrismarine"), Rituals.of("gemPrismarine")), "raining");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualWeather(RitualWeather.WeatherType.THUNDER, Rituals.of("dustPrismarine"), Rituals.of("gemPrismarine"), Rituals.of("gunpowder")), "thundering");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualDragonBreath(Rituals.of(Items.field_185157_bK), Rituals.of(Items.field_151061_bv), Rituals.of("blockPrismarine"), Rituals.of("netherrack"), Rituals.of("ingotGold")), "dragon_breath");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualDungeon(Rituals.of("blockSapphire"), Rituals.of("ingotGold")), "dungeon");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualArena(EntityWither.class, Rituals.of("blockAmethyst"), Rituals.of(new ItemStack(Items.field_151144_bL, 1, 1)), Rituals.of(new ItemStack(Items.field_151144_bL, 1, 1)), Rituals.of(new ItemStack(Items.field_151144_bL, 1, 1))), "wither_arena");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualCreateItem(new ItemStack(ArcaneWorldItems.ARCANE_HOE), Rituals.of(Items.field_151013_M), Rituals.of("gemDiamond"), Rituals.of("cropNetherWart"), Rituals.of(Items.field_179556_br), Rituals.of("dyeBlack")), "create_arcane_hoe");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualCreateItem(new ItemStack(ArcaneWorldItems.FANG_WAND), Rituals.of("stickWood"), Rituals.of("gemDiamond"), Rituals.of("ingotGold"), Rituals.of("dustGlowstone"), Rituals.of("enderpearl")), "create_evoking_wand");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualCreateItem(new ItemStack(ArcaneWorldItems.GLOWING_CHORUS), Rituals.of(Items.field_185161_cS), Rituals.of("obsidian"), Rituals.of("dustGlowstone"), Rituals.of(Items.field_151061_bv), Rituals.of(Items.field_185157_bK)), "create_glowing_chorus");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualCreateItem(new ItemStack(ArcaneWorldItems.BIOME_CRYSTAL), Rituals.of("gemDiamond"), Rituals.of("dustRedstone"), Rituals.of("grass"), Rituals.of(Items.field_151061_bv), Rituals.of(Items.field_185157_bK)), "create_biome_crystal");
        Rituals.createRitual((IForgeRegistry<Ritual>)event.getRegistry(), new RitualCreateItem(new ItemStack(ArcaneWorldItems.RECALLER), Rituals.of("obsidian"), Rituals.of(Items.field_151061_bv), Rituals.of("obsidian"), Rituals.of("gemAmethyst")), "create_recaller");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityZombie.class, Rituals.of(Items.field_151078_bh), true, "summon_zombie");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntitySkeleton.class, Rituals.of((Item)Items.field_151031_f), true, "summon_skeleton");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntitySpider.class, Rituals.of("string"), true, "summon_spider");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityCaveSpider.class, Rituals.of(Items.field_151070_bp), true, "summon_cave_spider");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityEnderman.class, Rituals.of("enderpearl"), true, "summon_enderpearl");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityPigZombie.class, Rituals.of("ingotGold"), true, "summon_zombie_pigman");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityBlaze.class, Rituals.of(Items.field_151072_bj), true, "summon_blaze");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityCreeper.class, Rituals.of("gunpowder"), true, "summon_creeper");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityElderGuardian.class, Rituals.of(Blocks.field_150360_v), true, "summon_elder_guardian");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityEndermite.class, Rituals.of(Items.field_151061_bv), true, "summon_endermite");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityGhast.class, Rituals.of(Items.field_151073_bk), true, "summon_ghast");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityGuardian.class, Rituals.of("dustPrismarine"), true, "summon_guardian");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityMagmaCube.class, Rituals.of(Items.field_151064_bs), true, "summon_magma_cube");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityShulker.class, Rituals.of(Blocks.field_190987_dv), true, "summon_shulker");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntitySilverfish.class, Rituals.of("stone"), true, "summon_silverfish");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntitySlime.class, Rituals.of("slimeball"), true, "summon_slimeball");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityWitch.class, Rituals.of("dustRedstone"), true, "summon_witch");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityVindicator.class, Rituals.of(Items.field_151036_c), true, "summon_vindicator");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityEvoker.class, Rituals.of(Items.field_190929_cY), true, "summon_evoker");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityPolarBear.class, Rituals.of(Blocks.field_150433_aE), true, "summon_polarbear");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityIllusionIllager.class, Rituals.of(Items.field_151066_bu), true, "summon_illusioner");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityBat.class, Rituals.of(Items.field_151102_aT), false, "summon_bat");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityChicken.class, Rituals.of("egg"), false, "summon_chicken");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityCow.class, Rituals.of(Items.field_151082_bd), false, "summon_cow");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityDonkey.class, Rituals.of(Items.field_151150_bK), false, "summon_donkey");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityHorse.class, Rituals.of(Items.field_151034_e), false, "summon_horse");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityMooshroom.class, Rituals.of(Blocks.field_150419_aX), false, "summon_mooshroom");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityOcelot.class, Rituals.of(Items.field_151115_aP), false, "summon_ocelot");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityParrot.class, Rituals.of("feather"), false, "summon_parrot");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityPig.class, Rituals.of(Items.field_151147_al), false, "summon_pig");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityRabbit.class, Rituals.of(Items.field_179556_br), false, "summon_rabbit");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntitySheep.class, Rituals.of(Items.field_179561_bm), false, "summon_sheep");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntitySquid.class, Rituals.of(new ItemStack(Items.field_151100_aR, 1, 0)), false, "summon_squid");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityVillager.class, Rituals.of("gemEmerald"), false, "summon_villager");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityLlama.class, Rituals.of(Blocks.field_150404_cg), false, "summon_llama");
        Rituals.createSummonRitual((IForgeRegistry<Ritual>)event.getRegistry(), EntityWolf.class, Rituals.of(Items.field_151083_be), false, "summon_wolf");
    }

    public static Ritual createRitual(IForgeRegistry<Ritual> registry, Ritual ritual, String name) {
        registry.register((IForgeRegistryEntry)((Ritual)ritual.setRegistryName("arcaneworld", name)).setTranslationKey("arcaneworld." + name));
        return ritual;
    }

    public static Ritual createSummonRitual(IForgeRegistry<Ritual> registry, Class<? extends EntityLiving> entity, Ingredient primary, boolean isHostile, String name) {
        Ingredient secondary = Rituals.of(isHostile ? "gemAmethyst" : "gemSapphire");
        Ingredient bones = Rituals.of("bone");
        return Rituals.createRitual(registry, new RitualSummon(entity, primary, secondary, bones), name);
    }

    public static Ingredient of(String oreDict) {
        return new OreIngredient(oreDict);
    }

    public static Ingredient of(Item item) {
        return Rituals.of(new ItemStack(item));
    }

    public static Ingredient of(Block block) {
        return Rituals.of(new ItemStack(block));
    }

    public static Ingredient of(ItemStack stack) {
        return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
    }
}

