/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.crafting.ritual;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Triple;
import party.lemons.arcaneworld.util.ArcaneWorldUtil;
import stanhebben.zenscript.annotations.ZenClass;

@ZenClass
public abstract class Ritual
extends IForgeRegistryEntry.Impl<Ritual> {
    private final List<Ingredient> ingredients;
    private boolean empty = false;
    private String unlocName;
    private List<Predicate<Triple<World, BlockPos, EntityPlayer>>> conditions = new ArrayList<com.google.common.base.Predicate>(Arrays.asList(Predicates.alwaysTrue()));
    private int requiredXpLevels = -1;

    public Ritual(Ingredient ... ingredients) {
        int i;
        this.ingredients = new ArrayList<Ingredient>();
        for (i = 0; i < 5; ++i) {
            this.ingredients.add(Ingredient.field_193370_a);
        }
        for (i = 0; i < ingredients.length; ++i) {
            this.ingredients.set(i, ingredients[i]);
        }
    }

    public Ritual setEmpty() {
        this.empty = true;
        return this;
    }

    public Ritual setTranslationKey(String key) {
        this.unlocName = key;
        return this;
    }

    public String getTranslationKey() {
        return this.unlocName;
    }

    public boolean canCast(@Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return ((Predicate)this.conditions.stream().reduce((c1, c2) -> c1.and(c2)).orElse(Predicates.alwaysTrue())).test(Triple.of((Object)world, (Object)pos, (Object)player));
    }

    public boolean matches(NonNullList<ItemStack> inputs) {
        if (this.isEmpty()) {
            return false;
        }
        ArrayList<Ingredient> ingreds = new ArrayList<Ingredient>(this.ingredients);
        ArrayList<Object> inputList = new ArrayList<Object>();
        for (int i = 0; i < inputs.size(); ++i) {
            inputList.add(inputs.get(i));
        }
        inputList.removeIf(ItemStack::func_190926_b);
        ingreds.removeIf(is -> is == Ingredient.field_193370_a);
        if (ingreds.size() != inputList.size()) {
            return false;
        }
        for (Ingredient ingredient : ingreds) {
            int removeIndex = -1;
            for (int i = 0; i < inputList.size(); ++i) {
                if (!ArcaneWorldUtil.ingredientMatch(ingredient, (ItemStack)inputList.get(i))) continue;
                removeIndex = i;
                break;
            }
            if (removeIndex == -1) {
                return false;
            }
            inputList.remove(removeIndex);
        }
        return true;
    }

    public abstract void onActivate(@Nonnull World var1, @Nonnull BlockPos var2, EntityPlayer var3, ItemStack ... var4);

    public final void internalActivate(@Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player, ItemStack ... items) {
        if (this.requiredXpLevels > 0 && !player.func_184812_l_()) {
            player.func_82242_a(-this.requiredXpLevels);
        }
        this.onActivate(world, pos, player, items);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean canDrop() {
        return true;
    }

    public List<Ingredient> getRequiredItems() {
        return this.ingredients;
    }

    public void addCondition(Predicate<Triple<World, BlockPos, EntityPlayer>> condition) {
        this.conditions.add(condition);
    }

    public void addXpCondition(int xpLevels) {
        this.addCondition(triple -> ((EntityPlayer)triple.getRight()).func_184812_l_() ? true : ((EntityPlayer)triple.getRight()).field_71068_ca >= xpLevels);
        this.requiredXpLevels = xpLevels;
    }

    public int getRequiredXpLevels() {
        return this.requiredXpLevels;
    }
}

