/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualCreateItem;

public class RitualRecipeWrapper
implements IRecipeWrapper {
    private Ritual ritual;
    private List<List<ItemStack>> ingreds;

    public RitualRecipeWrapper(IJeiHelpers helpers, Ritual ritual) {
        this.ritual = ritual;
        this.ingreds = helpers.getStackHelper().expandRecipeItemStackInputs(ritual.getRequiredItems());
    }

    public Ritual getRitual() {
        return this.ritual;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        String str = I18n.func_135052_a((String)this.ritual.getTranslationKey(), (Object[])new Object[0]);
        int length = Minecraft.func_71410_x().field_71466_p.func_78256_a(str);
        int height = Minecraft.func_71410_x().field_71466_p.field_78288_b;
        ArrayList<String> list = new ArrayList<String>();
        if (mouseX >= 2 && mouseX <= 2 + length && mouseY >= -2 && mouseY <= -2 + height) {
            list.add(TextFormatting.DARK_GRAY + this.ritual.getRegistryName().toString());
        }
        return list;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String translate = I18n.func_135052_a((String)this.ritual.getTranslationKey(), (Object[])new Object[0]);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(translate, 2, -2, 0x333333);
    }

    public void getIngredients(IIngredients iIngredients) {
        iIngredients.setInputLists(VanillaTypes.ITEM, this.ingreds);
        if (this.ritual instanceof RitualCreateItem) {
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)((RitualCreateItem)this.ritual).getItemstack());
        }
    }
}

