/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.compat.jei;

import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import party.lemons.arcaneworld.block.ArcaneWorldBlocks;
import party.lemons.arcaneworld.compat.jei.RitualRecipeWrapper;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipeWrapper> {
    public static final ResourceLocation RITUAL_BG = new ResourceLocation("arcaneworld", "textures/gui/ritual.png");
    public static final String ID = "arcaneworld.ritual";
    private IDrawable background;
    private IDrawable icon;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(RITUAL_BG, 40, 3, 120, 25);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ArcaneWorldBlocks.RITUAL_TABLE));
    }

    public String getUid() {
        return ID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"arcaneworld.jei.rituals", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Arcane World";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout layout, RitualRecipeWrapper wrapper, IIngredients ingredients) {
        int i;
        if (!(wrapper instanceof RitualRecipeWrapper)) {
            return;
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List output = ingredients.getOutputs(VanillaTypes.ITEM);
        int in = 0;
        for (i = 0; i < inputs.size(); ++i) {
            layout.getItemStacks().init(i, true, 3 + 18 * i, 6);
            layout.getItemStacks().set(i, (List)inputs.get(i));
            ++in;
        }
        if (output.size() > 0) {
            for (i = 0; i < ((List)output.get(0)).size(); ++i) {
                layout.getItemStacks().init(in, false, 3 + 20 * in, 6);
                layout.getItemStacks().set(in++, (ItemStack)((List)output.get(0)).get(i));
            }
        }
    }
}

