/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.compat.jei;

import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.startup.StackHelper;
import mezz.jei.transfer.BasicRecipeTransferHandler;
import mezz.jei.transfer.BasicRecipeTransferInfo;
import mezz.jei.transfer.RecipeTransferErrorTooltip;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import party.lemons.arcaneworld.block.ArcaneWorldBlocks;
import party.lemons.arcaneworld.compat.jei.RitualRecipeCategory;
import party.lemons.arcaneworld.compat.jei.RitualRecipeWrapper;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.crafting.ritual.RitualRegistry;
import party.lemons.arcaneworld.crafting.ritual.container.ContainerRitual;
import party.lemons.arcaneworld.crafting.ritual.container.GuiRitual;
import party.lemons.arcaneworld.item.ArcaneWorldItems;

@JEIPlugin
public class ArcaneWorldJEI
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new RitualRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void register(IModRegistry registry) {
        registry.handleRecipes(Ritual.class, r -> new RitualRecipeWrapper(registry.getJeiHelpers(), (Ritual)((Object)r)), "arcaneworld.ritual");
        registry.addRecipes((Collection)RitualRegistry.REGISTRY.getValuesCollection().stream().filter(r -> !r.isEmpty()).collect(Collectors.toList()), "arcaneworld.ritual");
        registry.addRecipeClickArea(GuiRitual.class, 0, 0, 20, 20, new String[]{"arcaneworld.ritual"});
        registry.addRecipeCatalyst((Object)new ItemStack(ArcaneWorldBlocks.RITUAL_TABLE), new String[]{"arcaneworld.ritual"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new BasicRecipeTransferHandler<ContainerRitual>((StackHelper)registry.getJeiHelpers().getStackHelper(), registry.getJeiHelpers().recipeTransferHandlerHelper(), (IRecipeTransferInfo)new BasicRecipeTransferInfo(ContainerRitual.class, "arcaneworld.ritual", 0, 5, 5, 36)){

            public Class<ContainerRitual> getContainerClass() {
                return ContainerRitual.class;
            }

            public IRecipeTransferError transferRecipe(ContainerRitual container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
                for (Ritual ritual : RitualRegistry.REGISTRY.getValuesCollection()) {
                    if (ritual.isEmpty()) continue;
                    NonNullList stacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
                    for (int i = 0; i < stacks.size(); ++i) {
                        ItemStack displayedIng = (ItemStack)((IGuiIngredient)recipeLayout.getItemStacks().getGuiIngredients().get(i)).getDisplayedIngredient();
                        if (displayedIng == null) continue;
                        stacks.set(i, (Object)displayedIng);
                    }
                    if (!ritual.matches((NonNullList<ItemStack>)stacks) || player.func_184812_l_() || ritual.getRequiredXpLevels() <= 0 || player.field_71068_ca >= ritual.getRequiredXpLevels()) continue;
                    return new RecipeTransferErrorTooltip(I18n.func_135052_a((String)"arcaneworld.tooltip.xp_needed", (Object[])new Object[]{ritual.getRequiredXpLevels()}));
                }
                return super.transferRecipe((Container)container, recipeLayout, player, maxTransfer, doTransfer);
            }
        }, "arcaneworld.ritual");
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ArcaneWorldItems.RECALL_EYE));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ArcaneWorldBlocks.RETURN_PORTAL));
    }
}

