/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import party.lemons.arcaneworld.ArcaneWorld;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.crafting.ritual.RitualRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.arcaneworld.RitualBuilder")
@ZenRegister
public class RitualBuilder {
    private boolean built;
    private Ritual ritual;
    private String name;
    private String displayName;

    public RitualBuilder(String name, String displayName, Ritual baseRitual) {
        this.ritual = baseRitual;
        this.name = name;
        this.displayName = displayName;
    }

    @ZenGetter(value="name")
    @ZenMethod
    public String getName() {
        return this.name;
    }

    @ZenMethod
    public RitualBuilder setName(String name) {
        if (this.built) {
            CraftTweakerAPI.logWarning((String)"Cannot set RitualBuilder attributes of an already-built ritual!");
            return this;
        }
        this.name = name;
        return this;
    }

    @ZenGetter(value="displayName")
    @ZenMethod
    public String getDisplayName() {
        return this.displayName;
    }

    @ZenMethod
    public RitualBuilder setDisplayName(String displayName) {
        if (this.built) {
            CraftTweakerAPI.logWarning((String)"Cannot set RitualBuilder attributes of an already-built ritual!");
            return this;
        }
        this.displayName = displayName;
        return this;
    }

    @ZenMethod
    public RitualBuilder setXp(int xp) {
        if (this.built) {
            CraftTweakerAPI.logWarning((String)"Cannot set RitualBuilder attributes of an already-built ritual!");
            return this;
        }
        this.ritual.addXpCondition(xp);
        return this;
    }

    @ZenMethod
    public Ritual build() {
        this.built = true;
        ResourceLocation location = new ResourceLocation("crafttweaker", this.name);
        this.ritual.setRegistryName(location);
        this.ritual.setTranslationKey(this.displayName);
        CraftTweakerAPI.apply((IAction)new RitualBuildAction(location, this));
        return this.ritual;
    }

    private class RitualBuildAction
    implements IAction {
        ResourceLocation resloc;
        RitualBuilder builder;

        public RitualBuildAction(ResourceLocation resloc, RitualBuilder builder) {
            this.resloc = resloc;
            this.builder = builder;
        }

        public String describe() {
            return String.format("Adding new RitualBuilder with name %s", this.builder.name);
        }

        public void apply() {
            if (RitualRegistry.REGISTRY.containsKey(this.resloc)) {
                ArcaneWorld.LOG.error("Ritual registry already contains a ritual with name \"" + RitualBuilder.this.name + "\"!");
                CraftTweakerAPI.logWarning((String)("Ritual registry already contains a ritual with name \"" + RitualBuilder.this.name + "\"!"));
            }
            RitualRegistry.REGISTRY.register((IForgeRegistryEntry)this.builder.ritual);
        }
    }
}

