/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.entity.EntityList;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import party.lemons.arcaneworld.compat.crafttweaker.IRitualEffect;
import party.lemons.arcaneworld.compat.crafttweaker.IRitualMatcher;
import party.lemons.arcaneworld.compat.crafttweaker.RitualBuilder;
import party.lemons.arcaneworld.compat.crafttweaker.RitualCustomCT;
import party.lemons.arcaneworld.crafting.ritual.RitualRegistry;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualArena;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualCommand;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualCreateItem;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualDragonBreath;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualDungeon;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualSummon;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualTime;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualWeather;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ArcaneWorld")
public class ArcaneWorldCrt {
    @ZenMethod
    public static void removeAll() {
        RitualRegistry.REGISTRY.clear();
    }

    @ZenMethod
    public static void remove(String registryName) {
        ResourceLocation loc = new ResourceLocation(registryName);
        if (RitualRegistry.REGISTRY.containsKey(loc)) {
            RitualRegistry.REGISTRY.remove(loc);
        }
    }

    @ZenMethod
    public static RitualBuilder createRitualSummon(String name, String displayName, String entity, IIngredient ... inputs) {
        Class e = EntityList.getClass((ResourceLocation)new ResourceLocation(entity));
        return new RitualBuilder(name, displayName, new RitualSummon(e, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static RitualBuilder createRitualDragonBreath(String name, String displayName, IIngredient ... inputs) {
        return new RitualBuilder(name, displayName, new RitualDragonBreath(ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static RitualBuilder createArenaRitual(String name, String displayName, String entity, IIngredient ... inputs) {
        Class e = EntityList.getClass((ResourceLocation)new ResourceLocation(entity));
        return new RitualBuilder(name, displayName, new RitualArena(e, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static RitualBuilder createRitualWeather(String name, String displayName, String weather, IIngredient ... inputs) {
        RitualWeather.WeatherType type = RitualWeather.WeatherType.CLEAR;
        switch (weather.toLowerCase()) {
            case "clear": {
                type = RitualWeather.WeatherType.CLEAR;
                break;
            }
            case "rain": {
                type = RitualWeather.WeatherType.RAIN;
                break;
            }
            case "thunder": {
                type = RitualWeather.WeatherType.THUNDER;
            }
        }
        return new RitualBuilder(name, displayName, new RitualWeather(type, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static RitualBuilder createRitualTime(String name, String displayName, int timeChange, IIngredient ... inputs) {
        return new RitualBuilder(name, displayName, new RitualTime(timeChange, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static RitualBuilder createRitualCreateItem(String name, String displayName, IItemStack result, IIngredient ... inputs) {
        return new RitualBuilder(name, displayName, new RitualCreateItem(CraftTweakerMC.getItemStack((IItemStack)result), ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static RitualBuilder createRitualDungeon(String name, String displayName, IIngredient ... inputs) {
        return new RitualBuilder(name, displayName, new RitualDungeon(ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static RitualBuilder createRitualCommand(String name, String displayName, String[] command, IIngredient ... inputs) {
        return new RitualBuilder(name, displayName, new RitualCommand(command, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static RitualBuilder createRitualCustomCT(String name, String displayName, IRitualMatcher matcher, IRitualEffect effect, IIngredient ... inputs) {
        return new RitualBuilder(name, displayName, new RitualCustomCT(matcher, effect, ArcaneWorldCrt.getIngredients(inputs)));
    }

    public static Ingredient[] getIngredients(IIngredient ... inputs) {
        Ingredient[] ingreds = new Ingredient[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            ingreds[i] = CraftTweakerMC.getIngredient((IIngredient)inputs[i]);
        }
        return ingreds;
    }
}

