/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="collective")
@Config.LangKey(value="Collective Config")
public class ModConfig {
    @Config.Comment(value={"When enabled, transfer the held items and armour from replaced entities by any of the Entity Spawn mods which depend on Collective."})
    public static boolean transferItemsBetweenReplacedEntities = true;
    @Config.Comment(value={"The amount of times Collective loops through possible mob drops to get them all procedurally. Drops are only generated when a dependent mod uses them. Lowering this can increase world load time but decrease accuracy."})
    @Config.RangeInt(min=1, max=200)
    public static int loopsAmountUsedToGetAllEntityDrops = 100;
    @Config.Comment(value={"The delay of the is-there-a-block-around-check around entities in ms. Used in mods which depends on a specific blockstate in the world. Increasing this number can increase TPS if needed."})
    @Config.RangeInt(min=0, max=3600000)
    public static int findABlockcheckAroundEntitiesDelayMs = 30000;
    @Config.Comment(value={"Please check out https://stopmodreposts.org/ for more information on why this feature exists."})
    public static boolean enableAntiRepostingCheck = true;
    @Config.Comment(value={"Enables pets for Patrons. Will be added in a future release."})
    public static boolean enablePatronPets = true;

    @Mod.EventBusSubscriber(modid="collective")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("collective")) {
                ConfigManager.sync((String)"collective", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

