/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.processing.churn;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.fluids.FluidKey;
import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.milk.shared.processing.churn.ChurnRecipe;
import growthcraft.milk.shared.processing.churn.IChurnRecipe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ChurnRegistry {
    private Map<Fluid, IChurnRecipe> recipes = new HashMap<Fluid, IChurnRecipe>();
    private Set<FluidKey> fluidIngredients = new HashSet<FluidKey>();

    public void addRecipe(@Nonnull IChurnRecipe recipe) {
        FluidStack fluidStack = recipe.getInputFluidStack();
        Fluid fluid = fluidStack.getFluid();
        if (this.recipes.containsKey(fluid)) {
            GrowthcraftLogger.getLogger("growthcraft_milk").warn("Overwriting existing churn recipe for {%s} with {%s}", (Object)fluidStack, (Object)recipe);
        } else {
            GrowthcraftLogger.getLogger("growthcraft_milk").debug("Adding new churn recipe {%s}", (Object)recipe);
        }
        this.fluidIngredients.add(new FluidKey(fluidStack));
        this.recipes.put(fluid, recipe);
    }

    public void addRecipe(@Nonnull FluidStack inputFluid, @Nonnull FluidStack outputFluid, @Nullable ItemStack outputItem, int churns) {
        Fluid fluid = inputFluid.getFluid();
        if (fluid == null) {
            throw new IllegalArgumentException("The provided input fluid is invalid.");
        }
        ChurnRecipe recipe = new ChurnRecipe(inputFluid, outputFluid, outputItem, churns);
        this.addRecipe(recipe);
    }

    public boolean isFluidIngredient(@Nullable Fluid fluid) {
        if (fluid != null) {
            return this.fluidIngredients.contains(new FluidKey(fluid));
        }
        return false;
    }

    public boolean isFluidIngredient(@Nullable FluidStack stack) {
        if (FluidTest.isValid(stack)) {
            return this.fluidIngredients.contains(new FluidKey(stack));
        }
        return false;
    }

    @Nullable
    public IChurnRecipe getRecipe(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return null;
        }
        IChurnRecipe recipe = this.recipes.get(fluid);
        if (recipe != null && recipe.isValidForRecipe(stack)) {
            return recipe;
        }
        return null;
    }
}

