/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.processing.cheesevat;

import growthcraft.core.shared.definition.IMultiFluidStacks;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.item.ItemTest;
import growthcraft.milk.shared.processing.cheesevat.ICheeseVatRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CheeseVatRecipe
implements ICheeseVatRecipe {
    private List<FluidStack> outputFluids;
    private List<ItemStack> outputItems;
    private List<IMultiFluidStacks> inputFluids;
    private List<IMultiItemStacks> inputItems;

    public CheeseVatRecipe(List<FluidStack> pOutputFluids, List<ItemStack> pOutputItems, List<IMultiFluidStacks> pInputFluids, List<IMultiItemStacks> pInputItems) {
        this.outputFluids = pOutputFluids;
        this.outputItems = pOutputItems;
        this.inputFluids = pInputFluids;
        this.inputItems = pInputItems;
    }

    @Override
    public List<FluidStack> getOutputFluidStacks() {
        return this.outputFluids;
    }

    @Override
    public List<ItemStack> getOutputItemStacks() {
        return this.outputItems;
    }

    @Override
    public List<IMultiFluidStacks> getInputFluidStacks() {
        return this.inputFluids;
    }

    @Override
    public List<IMultiItemStacks> getInputItemStacks() {
        return this.inputItems;
    }

    @Override
    public boolean isMatchingRecipe(@Nonnull List<FluidStack> fluids, @Nonnull List<ItemStack> items) {
        if (!FluidTest.isValidAndExpected(this.inputFluids, fluids)) {
            return false;
        }
        return ItemTest.containsExpectedItemsUnordered(this.inputItems, items);
    }

    @Override
    public boolean isFluidIngredient(@Nullable Fluid fluid) {
        for (IMultiFluidStacks stack : this.inputFluids) {
            if (!stack.containsFluid(fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFluidIngredient(@Nullable FluidStack fluidStack) {
        for (IMultiFluidStacks stack : this.inputFluids) {
            if (!stack.containsFluidStack(fluidStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isItemIngredient(@Nullable ItemStack itemStack) {
        for (IMultiItemStacks item : this.inputItems) {
            if (!item.containsItemStack(itemStack)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("CheeseVatRecipe(output_fluids: %s, output_items: %s, input_fluids: %s, input_items: %s)", this.outputFluids, this.outputItems, this.inputFluids, this.inputItems);
    }

    @Override
    public int getTime() {
        return 0;
    }
}

