/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.processing.cheesepress;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.item.ItemTest;
import growthcraft.milk.shared.processing.cheesepress.CheesePressRecipe;
import growthcraft.milk.shared.processing.cheesepress.ICheesePressRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class CheesePressRegistry {
    private List<ICheesePressRecipe> recipes = new ArrayList<ICheesePressRecipe>();

    public void addRecipe(@Nonnull ICheesePressRecipe recipe) {
        GrowthcraftLogger.getLogger("growthcraft_milk").debug("Adding new cheese press recipe {%s}", (Object)recipe);
        this.recipes.add(recipe);
    }

    public void addRecipe(@Nonnull ItemStack stack, @Nonnull ItemStack output, int time) {
        this.addRecipe(new CheesePressRecipe(stack, output, time));
    }

    public ICheesePressRecipe findRecipe(@Nullable ItemStack stack) {
        if (ItemTest.isValid(stack)) {
            for (ICheesePressRecipe recipe : this.recipes) {
                if (!recipe.isMatchingRecipe(stack)) continue;
                return recipe;
            }
        }
        return null;
    }
}

