/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity.device;

import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.processing.churn.IChurnRecipe;
import net.minecraft.inventory.IInventory;

public class Churn
extends DeviceProgressive<IChurnRecipe> {
    private DeviceFluidSlot inputFluidSlot;
    private DeviceFluidSlot outputFluidSlot;
    private DeviceInventorySlot outputSlot;

    public Churn(GrowthcraftTileDeviceBase te, int inputFluidSlot, int outputFluidSlot, int outputSlot) {
        super(te);
        this.outputFluidSlot = new DeviceFluidSlot(te, outputFluidSlot);
        this.inputFluidSlot = new DeviceFluidSlot(te, inputFluidSlot);
        this.outputSlot = new DeviceInventorySlot((IInventory)te, outputSlot);
    }

    @Override
    protected IChurnRecipe loadRecipe() {
        return MilkRegistry.instance().churn().getRecipe(this.inputFluidSlot.get());
    }

    @Override
    protected boolean canProcess() {
        IChurnRecipe recipe = (IChurnRecipe)this.getWorkingRecipe();
        if (recipe == null) {
            return false;
        }
        if (!this.inputFluidSlot.hasEnough(recipe.getInputFluidStack())) {
            return false;
        }
        if (!this.outputFluidSlot.hasCapacityFor(recipe.getOutputFluidStack())) {
            return false;
        }
        return this.outputSlot.hasCapacityFor(recipe.getOutputItemStack());
    }

    @Override
    public void process(IChurnRecipe recipe) {
        this.inputFluidSlot.consume(recipe.getInputFluidStack(), true);
        this.outputFluidSlot.fill(recipe.getOutputFluidStack(), true);
        this.outputSlot.increaseStack(recipe.getOutputItemStack());
    }

    @Override
    public void update() {
        IChurnRecipe recipe = (IChurnRecipe)this.getWorkingRecipe();
        if (this.canProcess()) {
            this.setTimeMax(recipe.getChurns());
            this.increaseTime();
            if (this.time >= (double)this.timeMax) {
                this.resetTime();
                this.process(recipe);
            }
        } else if (this.resetTime()) {
            this.markForUpdate(true);
        }
    }
}

