/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.utils;

import growthcraft.core.shared.config.TagParser;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeUtils {
    public static BiomeDictionary.Type[] types = new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WATER, BiomeDictionary.Type.MESA, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.VOID};

    private BiomeUtils() {
    }

    public static BiomeDictionary.Type fetchBiomeType(String name) throws BiomeTypeNotFound {
        String upcasedName = name.toUpperCase();
        for (BiomeDictionary.Type type : types) {
            if (!type.getName().equals(upcasedName)) continue;
            return type;
        }
        throw new BiomeTypeNotFound("Biome type '" + name + "' not found.");
    }

    public static boolean testBiomeTypeTags(Biome biome, TagParser.Tag[] tags) {
        if (tags.length == 0) {
            return false;
        }
        boolean hasMatching = false;
        for (TagParser.Tag tag : tags) {
            try {
                boolean res = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeUtils.fetchBiomeType(tag.value));
                if (tag.exclude && res) {
                    return false;
                }
                if (tag.must && !res) {
                    return false;
                }
                if (!res) continue;
                hasMatching = true;
            }
            catch (BiomeTypeNotFound ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return hasMatching;
    }

    public static boolean testBiomeTypeTagsTable(Biome biome, TagParser.Tag[][] tagTable) {
        for (TagParser.Tag[] row : tagTable) {
            if (!BiomeUtils.testBiomeTypeTags(biome, row)) continue;
            return true;
        }
        return false;
    }

    public static boolean testBiomeIdTags(String biomeId, TagParser.Tag[] tags) {
        for (TagParser.Tag tag : tags) {
            if (!tag.value.equals(biomeId)) continue;
            return true;
        }
        return false;
    }

    public static class BiomeTypeNotFound
    extends Exception {
        public static final long serialVersionUID = 1L;

        public BiomeTypeNotFound(String msg) {
            super(msg);
        }

        public BiomeTypeNotFound() {
        }
    }
}

