/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.utils;

import growthcraft.core.shared.utils.BoundUtils;
import net.minecraft.util.math.AxisAlignedBB;

public class BBox {
    public double[] boundsData = new double[6];
    public static final double EPSILON = 1.0E-6;

    public BBox() {
    }

    public BBox(float[] bounds) {
        this();
        assert (bounds.length == 6);
        this.boundsData[0] = bounds[0];
        this.boundsData[1] = bounds[1];
        this.boundsData[2] = bounds[2];
        this.boundsData[3] = bounds[3];
        this.boundsData[4] = bounds[4];
        this.boundsData[5] = bounds[5];
    }

    public BBox(double px0, double py0, double pz0, double px1, double py1, double pz1) {
        this();
        this.boundsData[0] = px0;
        this.boundsData[1] = py0;
        this.boundsData[2] = pz0;
        this.boundsData[3] = px1;
        this.boundsData[4] = py1;
        this.boundsData[5] = pz1;
    }

    public BBox translate(double x, double y, double z) {
        BBox newBBox = new BBox();
        BoundUtils.translateBounds(newBBox.boundsData, x, y, z, this.boundsData);
        return newBBox;
    }

    public BBox grow(double gx, double gy, double gz) {
        double x0 = this.boundsData[0] - gx;
        double y0 = this.boundsData[1] - gy;
        double z0 = this.boundsData[2] - gz;
        double x1 = this.boundsData[3] + gx;
        double y1 = this.boundsData[4] + gy;
        double z1 = this.boundsData[5] + gz;
        return new BBox(x0, y0, z0, x1, y1, z1);
    }

    public BBox scale(double px0, double py0, double pz0, double px1, double py1, double pz1) {
        double x0 = this.boundsData[0] * px0;
        double y0 = this.boundsData[1] * py0;
        double z0 = this.boundsData[2] * pz0;
        double x1 = this.boundsData[3] * px1;
        double y1 = this.boundsData[4] * py1;
        double z1 = this.boundsData[5] * pz1;
        return new BBox(x0, y0, z0, x1, y1, z1);
    }

    public BBox scale(double x, double y, double z) {
        return this.scale(x, y, z, x, y, z);
    }

    public BBox scale(double ps) {
        return this.scale(ps, ps, ps);
    }

    public double x0() {
        return this.boundsData[0];
    }

    public double y0() {
        return this.boundsData[1];
    }

    public double z0() {
        return this.boundsData[2];
    }

    public double x1() {
        return this.boundsData[3];
    }

    public double y1() {
        return this.boundsData[4];
    }

    public double z1() {
        return this.boundsData[5];
    }

    public double w() {
        return this.x1() - this.x0();
    }

    public double h() {
        return this.y1() - this.y0();
    }

    public double l() {
        return this.z1() - this.z0();
    }

    public boolean isEmpty() {
        return this.x0() + 1.0E-6 >= this.x1() || this.y0() + 1.0E-6 >= this.y1() || this.z0() + 1.0E-6 >= this.z1();
    }

    public boolean contains(double px, double py, double pz) {
        return this.x0() >= px && this.x1() <= px && this.y0() >= py && this.y1() <= py && this.z0() >= pz && this.z1() <= pz;
    }

    public static BBox newCube(double x, double y, double z, double w, double h, double l) {
        return new BBox(x, y, z, x + w, y + h, z + l);
    }

    public static BBox newCentered(double pw, double ph, double pl) {
        BBox result = new BBox();
        BoundUtils.centeredCubeBounds(result.boundsData, pw, ph, pl);
        return result;
    }

    public AxisAlignedBB toAxisAlignedBB() {
        return new AxisAlignedBB(this.x0(), this.y0(), this.z0(), this.x1(), this.y1(), this.z1());
    }
}

