/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.item;

import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.item.ItemTest;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemUtils {
    private ItemUtils() {
    }

    public static NBTTagCompound openTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static ItemStack[] clearInventorySlots(ItemStack[] invSlots, int expectedSize) {
        if (invSlots == null || invSlots.length != expectedSize) {
            return new ItemStack[expectedSize];
        }
        for (int i = 0; i < invSlots.length; ++i) {
            invSlots[i] = null;
        }
        return invSlots;
    }

    public static ItemStack increaseStack(ItemStack itemstack, int amount) {
        ItemStack containerItem = ItemUtils.getContainerItem(itemstack);
        itemstack.func_190920_e(MathHelper.func_76125_a((int)(itemstack.func_190916_E() + amount), (int)0, (int)itemstack.func_77976_d()));
        if (itemstack.func_190926_b()) {
            return containerItem;
        }
        return itemstack;
    }

    public static ItemStack getContainerItem(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (item.hasContainerItem(itemstack)) {
            return item.getContainerItem(itemstack);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack increaseStack(ItemStack itemstack) {
        return ItemUtils.increaseStack(itemstack, 1);
    }

    public static ItemStack consumeStack(ItemStack itemstack, int amount) {
        return ItemUtils.increaseStack(itemstack, -amount);
    }

    public static ItemStack consumeStack(ItemStack itemstack) {
        return ItemUtils.consumeStack(itemstack, 1);
    }

    public static ItemStack mergeStacksBang(ItemStack a, ItemStack b) {
        if (ItemUtils.isEmpty(a) && ItemUtils.isEmpty(b)) {
            return ItemStack.field_190927_a;
        }
        if (ItemUtils.isEmpty(a) && !ItemUtils.isEmpty(b)) {
            ItemStack result = b.func_77946_l();
            b.func_190920_e(0);
            return result;
        }
        if (!ItemUtils.isEmpty(a) && ItemUtils.isEmpty(b)) {
            return a;
        }
        if (a.func_77969_a(b)) {
            int newSize = MathHelper.func_76125_a((int)(a.func_190916_E() + b.func_190916_E()), (int)0, (int)a.func_77976_d());
            b.func_190920_e(b.func_190916_E() - (newSize - a.func_190916_E()));
            a.func_190920_e(newSize);
            return a;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isEmpty(ItemStack stack) {
        return !ItemTest.isValid(stack) || stack.func_77973_b() == Items.field_190931_a;
    }

    public static boolean isEmpty(List<ItemStack> stacks) {
        if (stacks != null) {
            for (ItemStack itemStack : stacks) {
                if (ItemUtils.isEmpty(itemStack)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmpty(IMultiItemStacks stacks) {
        return stacks == null || stacks.isEmpty();
    }

    public static ItemStack mergeStacks(ItemStack a, ItemStack b) {
        return ItemUtils.mergeStacksBang(a, !ItemUtils.isEmpty(b) ? b.func_77946_l() : b);
    }

    public static void replacePlayerCurrentItem(@Nonnull EntityPlayer player, ItemStack stack) {
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
    }

    public static ItemStack consumeStackOnPlayer(ItemStack itemstack, @Nonnull EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return itemstack;
        }
        ItemStack result = ItemUtils.consumeStack(itemstack);
        ItemUtils.replacePlayerCurrentItem(player, result);
        return result;
    }

    public static ItemStack decrPlayerInventorySlot(@Nonnull EntityPlayer player, int slot, int amount) {
        return player.field_71071_by.func_70298_a(slot, amount);
    }

    public static ItemStack decrPlayerCurrentInventorySlot(@Nonnull EntityPlayer player, int amount) {
        return player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, amount);
    }

    public static void addStackToPlayer(ItemStack itemstack, @Nonnull EntityPlayer player, World world, BlockPos pos, boolean checkCreative) {
        boolean flag;
        boolean bl = checkCreative ? !player.field_71075_bZ.field_75098_d : (flag = true);
        if (flag) {
            if (!player.field_71071_by.func_70441_a(itemstack)) {
                player.func_71019_a(itemstack, false);
            } else if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
        }
    }

    public static void addStackToPlayer(ItemStack itemstack, EntityPlayer player, World world, boolean checkCreative) {
        BlockPos pos = new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        ItemUtils.addStackToPlayer(itemstack, player, world, pos, checkCreative);
    }

    public static void addStackToPlayer(ItemStack itemstack, EntityPlayer player, boolean checkCreative) {
        ItemUtils.addStackToPlayer(itemstack, player, player.field_70170_p, checkCreative);
    }

    public static void spawnItemStack(World world, double x, double y, double z, ItemStack stack, Random random) {
        if (stack != null) {
            double f = random.nextDouble() * 0.8 + 0.1;
            double f1 = random.nextDouble() * 0.8 + 0.1;
            double f2 = random.nextDouble() * 0.8 + 0.1;
            EntityItem entityitem = new EntityItem(world, x + f, y + f1, z + f2, stack);
            float f3 = 0.05f;
            entityitem.field_70159_w = random.nextGaussian() * (double)0.05f;
            entityitem.field_70181_x = random.nextGaussian() * (double)0.05f + (double)0.2f;
            entityitem.field_70179_y = random.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void spawnItemStack(World world, BlockPos pos, ItemStack stack, Random random) {
        ItemUtils.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack, random);
    }

    public static void spawnBrokenItemStack(World world, BlockPos pos, ItemStack stack, Random random) {
        if (stack != null) {
            while (stack.func_190916_E() > 0) {
                int k1 = random.nextInt(21) + 10;
                if (k1 > stack.func_190916_E()) {
                    k1 = stack.func_190916_E();
                }
                ItemStack entityStack = stack.func_77979_a(k1);
                ItemUtils.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityStack, random);
            }
        }
    }

    public static void spawnItemStackAtEntity(ItemStack stack, Entity entity, Random random) {
        ItemUtils.spawnItemStack(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack, random);
    }

    public static void spawnItemStackAtTile(ItemStack stack, TileEntity tile, Random random) {
        BlockPos pos = tile.func_174877_v();
        ItemUtils.spawnItemStack(tile.func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack, random);
    }

    public static Block getBlock(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).func_179223_d();
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return block == ItemUtils.getBlock(stack);
    }

    public static boolean equals(Block block, int meta, ItemStack stack) {
        if (ItemUtils.isEmpty(stack)) {
            return false;
        }
        return block == ItemUtils.getBlock(stack) && meta == stack.func_77952_i();
    }

    public static boolean isIToolWrench(ItemStack item) {
        return false;
    }

    public static boolean isWrench(ItemStack item) {
        if (item == null) {
            return false;
        }
        return ItemUtils.isIToolWrench(item);
    }

    public static boolean canWrench(ItemStack item, EntityPlayer player, BlockPos pos) {
        return false;
    }

    public static void wrenchUsed(ItemStack item, EntityPlayer player, BlockPos pos) {
        if (item == null) {
            return;
        }
    }
}

