/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.io.nbt;

import growthcraft.core.shared.fluids.UnitFormatter;
import growthcraft.core.shared.io.nbt.NBTType;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;

public class TagFormatterFluidHandler {
    public static final TagFormatterFluidHandler INSTANCE = new TagFormatterFluidHandler();

    public List<String> format(List<String> list, NBTTagCompound tag) {
        int tankCount = tag.func_74762_e("tank_count");
        NBTTagList tanks = tag.func_150295_c("tanks", NBTType.COMPOUND.id);
        NBTTagList tankNames = tag.func_74764_b("tank_names") ? tag.func_150295_c("tank_names", NBTType.STRING.id) : null;
        for (int i = 0; i < tankCount; ++i) {
            NBTTagCompound tankTag = tanks.func_150305_b(i);
            String name = tankNames != null ? tankNames.func_150307_f(i) : null;
            String content = "";
            if (name != null && name.length() > 0) {
                content = content + I18n.func_74838_a((String)name) + " ";
            } else if (tankCount > 1) {
                content = content + TextFormatting.GRAY + I18n.func_74837_a((String)"format.tank_id", (Object[])new Object[]{tankTag.func_74762_e("tank_id") + 1}) + " ";
            }
            String fluidIDname = tankTag.func_74779_i("fluid_IDname");
            if (fluidIDname != null && !fluidIDname.equals("")) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankTag.func_74775_l("fluid"));
                String fluidName = UnitFormatter.fluidNameForContainer(fluidStack);
                content = content + UnitFormatter.fractionNum(fluidStack.amount, tankTag.func_74762_e("capacity")) + TextFormatting.GRAY + " " + I18n.func_74837_a((String)"format.tank.content_suffix", (Object[])new Object[]{fluidName});
            } else {
                content = content + UnitFormatter.noFluid();
            }
            list.add(content);
        }
        return list;
    }
}

