/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.inventory;

import growthcraft.core.shared.inventory.IInventoryWatcher;
import growthcraft.core.shared.io.nbt.INBTSerializableContext;
import growthcraft.core.shared.io.nbt.NBTHelper;
import growthcraft.core.shared.io.nbt.NBTType;
import growthcraft.core.shared.item.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class GrowthcraftInternalInventory
implements IInventory,
INBTSerializableContext {
    public static final int WILDCARD_SLOT = -1;
    protected String inventoryName = "grc.inventory.internal.name";
    protected ItemStack[] items;
    protected int maxSize;
    protected int maxStackSize;
    protected Object parent;

    public GrowthcraftInternalInventory(Object par, int size, int maxStack) {
        this.parent = par;
        this.maxSize = size;
        this.maxStackSize = maxStack;
        this.items = new ItemStack[this.maxSize];
    }

    public GrowthcraftInternalInventory(Object par, int size) {
        this(par, size, 64);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    protected void onSlotChanged(int index) {
        if (this.parent instanceof IInventoryWatcher) {
            ((IInventoryWatcher)this.parent).onInventoryChanged(this, index);
        } else if (this.parent instanceof IInventory) {
            ((IInventory)this.parent).func_70296_d();
        }
    }

    public void func_70296_d() {
        this.onSlotChanged(-1);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.getMaxSize(); ++i) {
            this.items[i] = null;
        }
        this.onSlotChanged(-1);
    }

    @Deprecated
    public void clearInventory() {
        this.func_174888_l();
    }

    protected void readFromNBT(NBTTagList data) {
        this.items = ItemUtils.clearInventorySlots(this.items, this.func_70302_i_());
        NBTHelper.readInventorySlotsFromNBT(this.items, data);
        this.onSlotChanged(-1);
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagList list = data.func_150295_c(name, NBTType.COMPOUND.id);
        if (list != null) {
            this.readFromNBT(list);
        }
    }

    protected void writeToNBT(NBTTagList data) {
        NBTHelper.writeInventorySlotsToNBT(this.items, data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagList invData = new NBTTagList();
        this.writeToNBT(invData);
        data.func_74782_a(name, (NBTBase)invData);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174889_b(EntityPlayer _player) {
    }

    public void func_174886_c(EntityPlayer _player) {
    }

    public boolean func_70300_a(EntityPlayer _player) {
        return true;
    }

    public int func_70302_i_() {
        return this.maxSize;
    }

    public int func_70297_j_() {
        return this.maxStackSize;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public GrowthcraftInternalInventory setInventoryName(String name) {
        this.inventoryName = name;
        return this;
    }

    public String func_70005_c_() {
        return this.inventoryName;
    }

    public ItemStack func_70301_a(int index) {
        ItemStack stack = this.items[index];
        return stack != null ? stack : ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack oldStack = this.items[index];
        this.items[index] = stack;
        if (!ItemUtils.isEmpty(stack) && stack.func_190916_E() > this.func_70297_j_()) {
            int discarded = stack.func_190916_E() - this.func_70297_j_();
            this.items[index].func_190920_e(this.func_70297_j_());
            if (discarded > 0 && this.parent instanceof IInventoryWatcher) {
                ((IInventoryWatcher)this.parent).onItemDiscarded(this, stack, index, discarded);
            }
        }
        if (oldStack != stack) {
            this.onSlotChanged(index);
        }
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.items[index];
        this.items[index] = null;
        if (!ItemUtils.isEmpty(stack)) {
            this.onSlotChanged(index);
        }
        return stack;
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.items[index] != null) {
            ItemStack itemstack;
            if (this.items[index].func_190916_E() <= amount) {
                itemstack = this.items[index];
                this.items[index] = null;
            } else {
                itemstack = this.items[index].func_77979_a(amount);
                if (this.items[index].func_190926_b()) {
                    this.items[index] = null;
                }
            }
            this.onSlotChanged(index);
            return itemstack;
        }
        return null;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (ItemUtils.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

