/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.inventory;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.tileentity.feature.IInteractionObject;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GrowthcraftGuiProvider
implements IGuiHandler {
    public final Map<String, Class> guiMap = new HashMap<String, Class>();

    public void register(String name, Class guiClass) {
        if (this.guiMap.containsKey(name)) {
            GrowthcraftLogger.getLogger("growthcraft").warn("Overwriting Existing Gui mapping: %s with `%s`", (Object)name, (Object)guiClass);
        }
        this.guiMap.put(name, guiClass);
    }

    private String typeName(Object inventory) {
        if (inventory == null) {
            return "NULL";
        }
        return inventory.getClass().getName();
    }

    private Constructor findConstructor(Constructor[] c, InventoryPlayer inventory, Object te) {
        Class<?> teClass = te.getClass();
        Class<?> invClass = inventory.getClass();
        for (Constructor con : c) {
            Class<?>[] types = con.getParameterTypes();
            if (types.length != 2 || !types[0].isAssignableFrom(invClass) || !types[1].isAssignableFrom(teClass)) continue;
            return con;
        }
        return null;
    }

    private Object createContainerInstance(@Nonnull Class containerClass, @Nonnull InventoryPlayer inventory, Object te) {
        try {
            Constructor[] c = containerClass.getConstructors();
            if (c.length == 0) {
                throw new InvalidGuiElement("Invalid Gui Element Class " + containerClass.getName());
            }
            Constructor target = this.findConstructor(c, inventory, te);
            if (target == null) {
                throw new IllegalStateException("Cannot find " + containerClass.getName() + "( " + this.typeName(inventory) + ", " + this.typeName(te) + " )");
            }
            return target.newInstance(inventory, te);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof IInteractionObject) {
            IInteractionObject iobj = (IInteractionObject)te;
            return iobj.createContainer(player.field_71071_by, player);
        }
        GrowthcraftLogger.getLogger("growthcraft").error("Container requested for TE but TE was not a IInteractionObject tile_entity=%s id=%d", (Object)te, (Object)ID);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof IInteractionObject) {
            IInteractionObject iobj = (IInteractionObject)te;
            String guiId = iobj.getGuiID();
            Class klass = this.guiMap.get(guiId);
            if (klass != null) {
                return this.createContainerInstance(klass, player.field_71071_by, te);
            }
            GrowthcraftLogger.getLogger("growthcraft").error("Missing GUI Class for %s", (Object)guiId);
        }
        return null;
    }

    public static class InvalidGuiElement
    extends IllegalStateException {
        public static final long serialVersionUID = 1L;

        public InvalidGuiElement(String str) {
            super(str);
        }
    }
}

