/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.handlers;

import growthcraft.core.shared.item.IFluidContainerItem;
import growthcraft.core.shared.legacy.FluidContainerRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerContainerItemWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    @Nonnull
    protected ItemStack container;

    public FluidHandlerContainerItemWrapper(ItemStack container) {
        this.container = container;
    }

    @Nullable
    public FluidStack getFluidStack() {
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem(this.container);
        if (fluidStack != null) {
            return fluidStack;
        }
        Item item = this.container.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)item).getFluidStack(this.container);
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack == null) {
            return new FluidTankProperties[0];
        }
        return new FluidTankProperties[]{new FluidTankProperties(fluidStack, fluidStack.amount)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null) {
            return 0;
        }
        ItemStack newContainer = FluidContainerRegistry.fillFluidContainer(resource, this.container);
        if (newContainer == null) {
            return 0;
        }
        if (doFill) {
            this.container = newContainer;
        }
        return FluidContainerRegistry.getContainerCapacity(newContainer);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack == null) {
            return null;
        }
        if (this.container.func_190926_b() || resource == null || resource.amount < fluidStack.amount) {
            return null;
        }
        if (fluidStack.isFluidEqual(resource)) {
            if (doDrain) {
                ItemStack newContainer = FluidContainerRegistry.drainFluidContainer(this.container);
                if (newContainer == null) {
                    return null;
                }
                this.container = newContainer;
            }
            return fluidStack;
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack == null) {
            return null;
        }
        fluidStack = fluidStack.copy();
        fluidStack.amount = Math.min(maxDrain, fluidStack.amount);
        return this.drain(fluidStack, doDrain);
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
        }
        return null;
    }
}

