/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.legacy.FluidContainerRegistry;
import growthcraft.core.shared.utils.ExperienceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class GrowthcraftFluidUtils {
    private static Map<Fluid, List<FluidContainerRegistry.FluidContainerData>> fluidData;

    private GrowthcraftFluidUtils() {
    }

    public static Map<Fluid, List<FluidContainerRegistry.FluidContainerData>> getFluidData() {
        if (fluidData == null || fluidData.size() == 0) {
            fluidData = new HashMap<Fluid, List<FluidContainerRegistry.FluidContainerData>>();
            for (FluidContainerRegistry.FluidContainerData data : Arrays.asList(FluidContainerRegistry.getRegisteredFluidContainerData())) {
                if (!fluidData.containsKey(data.fluid.getFluid())) {
                    fluidData.put(data.fluid.getFluid(), new ArrayList());
                }
                fluidData.get(data.fluid.getFluid()).add(data);
            }
        }
        return fluidData;
    }

    public static List<ItemStack> getFluidContainers(FluidStack ... fluids) {
        if (fluids.length == 1) {
            ArrayList<ItemStack> fluidContainers = new ArrayList<ItemStack>();
            FluidStack fluidStack = fluids[0];
            for (FluidContainerRegistry.FluidContainerData data : GrowthcraftFluidUtils.getFluidData().get(fluidStack.getFluid())) {
                if (data.fluid.amount < fluidStack.amount) continue;
                fluidContainers.add(data.filledContainer);
            }
            return fluidContainers;
        }
        return GrowthcraftFluidUtils.getFluidContainers(Arrays.asList(fluids));
    }

    public static List<ItemStack> getFluidContainers(Collection<FluidStack> fluids) {
        ArrayList<ItemStack> fluidContainers = new ArrayList<ItemStack>();
        for (FluidStack fluidStack : fluids) {
            fluidContainers.addAll(GrowthcraftFluidUtils.getFluidContainers(fluidStack));
        }
        return fluidContainers;
    }

    public static List<Fluid> getFluidsByNames(List<String> names) {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        for (String name : names) {
            fluids.add(FluidRegistry.getFluid((String)name));
        }
        return fluids;
    }

    public static boolean doesFluidExist(String name) {
        return FluidRegistry.getFluid((String)name) != null && FluidRegistry.isFluidRegistered((String)name);
    }

    public static boolean doesFluidExist(Fluid fluid) {
        return fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid);
    }

    public static boolean doesFluidsExist(Fluid[] fluid) {
        for (int i = 0; i < fluid.length; ++i) {
            if (GrowthcraftFluidUtils.doesFluidExist(fluid[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean playerFillTank(World world, BlockPos pos, IFluidHandler tank, ItemStack held, EntityPlayer player) {
        if (ItemUtils.isEmpty(held)) {
            return false;
        }
        FluidStack heldContents = FluidUtil.getFluidContained((ItemStack)held);
        FluidActionResult fac = null;
        if (heldContents == null) {
            heldContents = FluidContainerRegistry.getFluidForFilledItem(held);
            if (heldContents == null) {
                return false;
            }
            if (tank.fill(heldContents, false) <= 0) {
                return false;
            }
        } else {
            fac = FluidUtil.tryEmptyContainer((ItemStack)held, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)false);
            if (FluidActionResult.FAILURE.equals(fac)) {
                return false;
            }
        }
        if (!world.field_72995_K) {
            ItemStack containerItem = null;
            if (fac != null) {
                fac = FluidUtil.tryEmptyContainer((ItemStack)held, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                if (FluidActionResult.FAILURE.equals(fac)) {
                    return false;
                }
                containerItem = fac.getResult();
            } else {
                tank.fill(heldContents, true);
                containerItem = FluidContainerRegistry.drainFluidContainer(held);
            }
            if (!player.field_71071_by.func_70441_a(containerItem)) {
                if (containerItem != null) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, containerItem));
                }
            } else if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
                if (held.func_190926_b()) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
        }
        return true;
    }

    public static FluidStack playerDrainTank(World world, BlockPos pos, IFluidHandler tank, ItemStack held, EntityPlayer player, boolean expbool, int amount, float exp) {
        if (ItemUtils.isEmpty(held)) {
            return null;
        }
        FluidStack available = tank.drain(Integer.MAX_VALUE, false);
        if (available == null) {
            return null;
        }
        FluidActionResult fac = FluidUtil.tryFillContainer((ItemStack)held, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)false);
        if (FluidActionResult.FAILURE.equals(fac) && FluidContainerRegistry.fillFluidContainer(available, held) == null) {
            return null;
        }
        if (!world.field_72995_K) {
            FluidStack heldContents;
            ItemStack filled;
            fac = FluidUtil.tryFillContainer((ItemStack)held, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
            if (FluidActionResult.FAILURE.equals(fac)) {
                filled = FluidContainerRegistry.fillFluidContainer(available, held);
                heldContents = FluidContainerRegistry.getFluidForFilledItem(filled);
                if (heldContents == null) {
                    return null;
                }
                tank.drain(heldContents.amount, true);
            } else {
                filled = fac.getResult();
                heldContents = FluidUtil.getFluidContained((ItemStack)filled);
            }
            if (!player.field_71071_by.func_70441_a(filled)) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, filled));
            } else if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
                if (held.func_190926_b()) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
            if (expbool) {
                ExperienceUtils.spawnExp(amount * heldContents.amount / tank.getTankProperties()[0].getCapacity(), exp, player);
            }
        }
        return available;
    }

    public static FluidStack playerDrainTank(World world, BlockPos pos, IFluidHandler fh, ItemStack held, EntityPlayer player) {
        return GrowthcraftFluidUtils.playerDrainTank(world, pos, fh, held, player, false, 0, 0.0f);
    }

    public static FluidStack removeStackTags(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.tag == null) {
            return stack;
        }
        return new FluidStack(stack.getFluid(), stack.amount);
    }

    public static FluidStack exchangeFluid(FluidStack stack, Fluid newFluid) {
        return new FluidStack(newFluid, stack.amount);
    }

    public static FluidStack replaceFluidStack(String fluidId, FluidStack srcStack) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidId);
        if (fluid == null) {
            return null;
        }
        return GrowthcraftFluidUtils.replaceFluidStack(fluid, srcStack);
    }

    public static FluidStack replaceFluidStack(Fluid fluid, FluidStack srcStack) {
        if (fluid == null || srcStack == null) {
            return new FluidStack(FluidRegistry.WATER, 0);
        }
        return new FluidStack(fluid, srcStack.amount);
    }

    public static FluidStack updateFluidStackAmount(FluidStack srcStack, int amount) {
        if (srcStack == null) {
            return new FluidStack(FluidRegistry.WATER, amount);
        }
        srcStack.amount = amount;
        return srcStack;
    }

    public static FluidTankInfo[] convertTankPropsToInfo(IFluidTankProperties[] tankProperties) {
        FluidTankInfo[] infos = new FluidTankInfo[tankProperties.length];
        for (int i = 0; i < tankProperties.length; ++i) {
            IFluidTankProperties prop = tankProperties[i];
            infos[i] = new FluidTankInfo(prop.getContents(), prop.getCapacity());
        }
        return infos;
    }

    public static FluidStack replaceFluidStackTags(FluidStack from, FluidStack tagsFrom) {
        if (from == null) {
            return null;
        }
        if (tagsFrom == null) {
            return from;
        }
        if (tagsFrom.tag == null) {
            if (from.tag != null) {
                return new FluidStack(from.getFluid(), from.amount);
            }
            return from;
        }
        return new FluidStack(from.getFluid(), from.amount, tagsFrom.tag);
    }
}

