/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import growthcraft.core.shared.fluids.IFluidTanks;
import growthcraft.core.shared.io.nbt.INBTSerializableContext;
import growthcraft.core.shared.io.stream.IStreamable;
import growthcraft.core.shared.io.stream.StreamUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTanks
implements IFluidTanks,
INBTSerializableContext,
IStreamable {
    private FluidTank[] tanks;

    public FluidTanks(FluidTank[] ts) {
        this.tanks = ts;
    }

    @Override
    public int getTankCount() {
        return this.tanks.length;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfos = new FluidTankInfo[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            tankInfos[i] = this.tanks[i].getInfo();
        }
        return tankInfos;
    }

    public IFluidTankProperties[] getTankProperties(EnumFacing from) {
        int propCount = 0;
        for (FluidTank tank : this.tanks) {
            propCount += tank.getTankProperties().length;
        }
        IFluidTankProperties[] summedProps = new IFluidTankProperties[propCount];
        int i = 0;
        for (FluidTank tank : this.tanks) {
            for (IFluidTankProperties prop : tank.getTankProperties()) {
                summedProps[i++] = prop;
            }
        }
        return summedProps;
    }

    @Override
    public FluidTank[] getFluidTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank getFluidTank(int slot) {
        return this.tanks[slot];
    }

    @Override
    public void clearTank(int slot) {
        this.tanks[slot].setFluid(null);
    }

    @Override
    public int getFluidAmountScaled(int scalar, int slot) {
        int cap = this.tanks[slot].getCapacity();
        if (cap <= 0) {
            return 0;
        }
        return this.getFluidAmount(slot) * scalar / cap;
    }

    @Override
    public float getFluidAmountRate(int slot) {
        int cap = this.tanks[slot].getCapacity();
        if (cap <= 0) {
            return 0.0f;
        }
        return (float)this.getFluidAmount(slot) / (float)cap;
    }

    @Override
    public boolean isFluidTankFilled(int slot) {
        return this.getFluidAmount(slot) > 0;
    }

    @Override
    public boolean isFluidTankFull(int slot) {
        return this.getFluidAmount(slot) >= this.tanks[slot].getCapacity();
    }

    @Override
    public boolean isFluidTankEmpty(int slot) {
        return this.getFluidAmount(slot) <= 0;
    }

    @Override
    public int getFluidAmount(int slot) {
        return this.tanks[slot].getFluidAmount();
    }

    @Override
    public FluidStack getFluidStack(int slot) {
        return this.tanks[slot].getFluid();
    }

    @Override
    public FluidStack drainFluidTank(int slot, int amount, boolean doDrain) {
        return this.tanks[slot].drain(amount, doDrain);
    }

    @Override
    public int fillFluidTank(int slot, FluidStack fluid, boolean doFill) {
        return this.tanks[slot].fill(fluid, doFill);
    }

    @Override
    public void setFluidStack(int slot, FluidStack stack) {
        this.tanks[slot].setFluid(stack);
    }

    @Override
    public Fluid getFluid(int slot) {
        FluidStack stack = this.getFluidStack(slot);
        if (stack == null) {
            return null;
        }
        return stack.getFluid();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].setFluid(null);
            if (!nbt.func_74764_b("Tank" + i)) continue;
            this.tanks[i].readFromNBT(nbt.func_74775_l("Tank" + i));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_74764_b(name)) {
            this.readFromNBT(nbt.func_74775_l(name));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("tank_count", this.tanks.length);
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            this.tanks[i].writeToNBT(tag);
            nbt.func_74782_a("Tank" + i, (NBTBase)tag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        nbt.func_74782_a(name, (NBTBase)tag);
    }

    @Override
    public boolean readFromStream(ByteBuf stream) {
        for (int i = 0; i < this.tanks.length; ++i) {
            StreamUtils.readFluidTank(stream, this.tanks[i]);
        }
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf stream) {
        for (int i = 0; i < this.tanks.length; ++i) {
            StreamUtils.writeFluidTank(stream, this.tanks[i]);
        }
        return false;
    }
}

